/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.rf.Rf4ceAuthenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RfRemote {
    public String name = null;
    public Hex extAddr = null;
    public int nodeCaps = 0;
    public Hex vendorID = null;
    public Hex vendorString = null;
    public Hex userString = null;
    public Hex devTypes = null;
    public Hex profiles = null;
    public List<Pairing> pairings = null;
    public boolean changed = false;

    public RfRemote() {
        this.pairings = new ArrayList<Pairing>();
    }

    public RfRemote(Hex extAddr) {
        this.extAddr = extAddr;
        this.pairings = new ArrayList<Pairing>();
    }

    public String getRfData(Rf4ceAuthenticator.Source source, int pairIndex) {
        int appCaps = 0;
        int len = 0;
        Hex[] data = null;
        Hex nodeHex = null;
        if (source == Rf4ceAuthenticator.Source.CONTROLLER) {
            nodeHex = new Hex(new short[]{(short)this.nodeCaps});
            data = new Hex[]{nodeHex, this.vendorID, this.vendorString, this.userString, this.devTypes, this.profiles};
        } else if (source == Rf4ceAuthenticator.Source.TARGET) {
            Pairing pair = this.pairings.get(pairIndex);
            nodeHex = new Hex(new short[]{(short)pair.getPeerNodeCaps()});
            data = new Hex[]{nodeHex, pair.peerVendorID, pair.peerVendorString, pair.peerUserString, pair.getPeerDevTypes(), pair.peerProfiles};
        }
        if (data[0] == null && data[1] == null && data[2] == null && data[3] == null && data[4] == null && data[5] == null) {
            return null;
        }
        if (data[3] != null) {
            appCaps = 1;
        }
        if (data[4] != null) {
            len = data[4].length();
            if (len > 3) {
                return null;
            }
            appCaps |= len << 1;
        }
        if (data[5] != null) {
            len = data[5].length();
            if (len > 7) {
                return null;
            }
            appCaps |= len << 4;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(data[0] != null ? data[0].toString() : "XX");
        sb.append(" ");
        sb.append(data[1] != null ? data[1].toString() : "XX XX");
        sb.append(" ");
        sb.append(data[2] != null ? data[2].toString() : "XX XX XX XX XX XX XX");
        sb.append(String.format(" %02X ", appCaps));
        if (data[3] != null) {
            sb.append(data[3].toString());
        }
        sb.append(" ");
        if (data[4] != null) {
            sb.append(data[4].toString());
        }
        sb.append(" ");
        if (data[5] != null) {
            sb.append(data[5].toString());
        }
        return sb.toString();
    }

    public void importRfData(String rfData, Rf4ceAuthenticator.Source source, int pairIndex) {
        int len;
        if (rfData == null) {
            return;
        }
        Hex rfHex = new Hex(rfData.replaceAll("XX", "00"));
        Hex[] data = new Hex[6];
        data[0] = rfData.charAt(0) == 'X' ? null : rfHex.subHex(0, 1);
        data[1] = rfData.charAt(3) == 'X' ? null : rfHex.subHex(1, 2);
        data[2] = rfData.charAt(9) == 'X' ? null : rfHex.subHex(3, 7);
        short appCaps = rfHex.getData()[10];
        int pos = 11;
        if ((appCaps & 1) == 1) {
            data[3] = rfHex.subHex(pos, 15);
            pos += 15;
        }
        if ((len = appCaps >> 1 & 3) > 0) {
            data[4] = rfHex.subHex(pos, len);
            pos += len;
        }
        if ((len = appCaps >> 4 & 7) > 0) {
            data[5] = rfHex.subHex(pos, len);
            pos += len;
        }
        if (source == Rf4ceAuthenticator.Source.CONTROLLER) {
            this.nodeCaps = data[0].getData()[0];
            this.vendorID = data[1];
            this.vendorString = data[2];
            this.userString = data[3];
            this.devTypes = data[4];
            this.profiles = data[5];
        } else if (source == Rf4ceAuthenticator.Source.TARGET) {
            Pairing pair = this.pairings.get(pairIndex);
            pair.setPeerNodeCaps(data[0].getData()[0]);
            pair.setPeerVendorID(data[1]);
            pair.peerVendorString = data[2];
            pair.peerUserString = data[3];
            pair.setPeerDevTypes(data[4]);
            pair.peerProfiles = data[5];
        }
    }

    public String toString() {
        return this.name;
    }

    public static class Pairing {
        private Hex table = new Hex(39);
        public Hex peerVendorID = null;
        public Hex peerVendorString = null;
        public Hex peerUserString = null;
        public Hex peerProfiles = null;

        public Pairing() {
            Arrays.fill(this.table.getData(), (short)0);
        }

        public Pairing(Hex table) {
            this();
            if (table.length() >= 39 && table.length() <= 42) {
                this.table = table;
            } else if (table.length() == 128) {
                this.setNwkAddr(table.subHex(59, 2));
                this.setChannel(table.getData()[57]);
                this.setPeerExtAddr(table.subHex(63, 8));
                this.setPanID(table.subHex(71, 2));
                this.setPeerNwkAddr(table.subHex(61, 2));
                this.setPeerNodeCaps(table.getData()[58]);
                this.setSecurityKey(table.subHex(73, 16));
            }
        }

        public Pairing(String tableString) {
            this(new Hex(tableString.replaceAll("XX", "00")));
            if (tableString.contains("XX")) {
                this.peerVendorID = null;
            }
        }

        public Hex getTable() {
            return this.table;
        }

        public String getTableString() {
            if (this.peerVendorID != null) {
                return this.table.toString();
            }
            return this.table.subHex(0, 34).toString() + " XX XX " + this.table.subHex(36).toString();
        }

        public void setTable(Hex table) {
            this.table = table;
        }

        public int getPairRef() {
            return this.table.getData()[0];
        }

        public void setPairRef(int ref) {
            this.table.getData()[0] = (short)ref;
        }

        public Hex getNwkAddr() {
            return this.table.subHex(1, 2);
        }

        public void setNwkAddr(Hex nwkAddr) {
            this.table.put(nwkAddr, 1);
        }

        public int getChannel() {
            return this.table.getData()[3];
        }

        public void setChannel(int channel) {
            this.table.getData()[3] = (short)channel;
        }

        public Hex getPeerExtAddr() {
            return this.table.subHex(4, 8);
        }

        public void setPeerExtAddr(Hex extAddr) {
            this.table.put(extAddr, 4);
        }

        public Hex getPanID() {
            return this.table.subHex(12, 2);
        }

        public void setPanID(Hex panID) {
            this.table.put(panID, 12);
        }

        public Hex getPeerNwkAddr() {
            return this.table.subHex(14, 2);
        }

        public void setPeerNwkAddr(Hex nwkAddr) {
            this.table.put(nwkAddr, 14);
        }

        public int getPeerNodeCaps() {
            return this.table.getData()[16];
        }

        public void setPeerNodeCaps(int nodeCaps) {
            this.table.getData()[16] = (short)nodeCaps;
        }

        public Hex getSecurityKey() {
            if (this.table.getData()[17] == 1) {
                return this.table.subHex(18, 16);
            }
            return null;
        }

        public void setSecurityKey(Hex key) {
            if (key == null) {
                this.table.getData()[17] = 0;
            } else {
                this.table.getData()[17] = 1;
                this.table.put(key, 18);
            }
        }

        public void setPeerVendorID(Hex vid) {
            this.peerVendorID = vid;
            if (vid != null) {
                this.table.put(vid, 34);
            }
        }

        public Hex getPeerDevTypes() {
            return this.table.subHex(36, 3);
        }

        public void setPeerDevTypes(Hex devTypes) {
            Hex empty = new Hex("00 00 00");
            this.table.put(empty, 36);
            this.table.put(devTypes, 36);
        }
    }
}

