/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.rf.RfRemote;
import com.hifiremote.jp1.rf.RfRemoteTableModel;
import com.hifiremote.jp1.rf.RfTools;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RfRemotePanel
extends JPanel
implements ActionListener {
    RfTools owner = null;
    JComboBox<RfRemote> remotesBox = null;
    JComboBox<Integer> pairingsBox = null;
    JP1Table remoteTable = null;

    public RfRemotePanel(RfTools owner) {
        double b = 10.0;
        double i = 5.0;
        double f = -1.0;
        double p = -2.0;
        double[][] size = new double[][]{{b, p, b, f, b, p, b, 100.0, b}, {b, p, b}};
        this.owner = owner;
        this.setLayout(new BorderLayout());
        TableLayout tl = new TableLayout(size);
        JPanel identPanel = new JPanel(tl);
        identPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JLabel label = new JLabel("RF Remote:", 4);
        identPanel.add((Component)label, "1, 1");
        RfRemote[] rfRemotes = owner.getRfRemotesList().toArray(new RfRemote[0]);
        this.remotesBox = new JComboBox<RfRemote>(rfRemotes);
        this.remotesBox.addActionListener(this);
        this.pairingsBox = new JComboBox();
        identPanel.add(this.remotesBox, "3, 1");
        label = new JLabel("Pairing ref:", 4);
        identPanel.add((Component)label, "5, 1");
        identPanel.add(this.pairingsBox, "7, 1");
        this.add((Component)identPanel, "First");
        RfRemoteTableModel remoteTableModel = new RfRemoteTableModel();
        this.remoteTable = new JP1Table(remoteTableModel);
        this.remoteTable.initColumns();
        JScrollPane scrollPane = new JScrollPane(this.remoteTable);
        this.add((Component)scrollPane, "Center");
        if (rfRemotes.length > 0) {
            this.remotesBox.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.remotesBox) {
                RfRemote rfRemote = (RfRemote)this.remotesBox.getSelectedItem();
                this.setData(rfRemote);
                Integer[] pairIndices = new Integer[rfRemote.pairings.size()];
                for (int i = 0; i < pairIndices.length; ++i) {
                    pairIndices[i] = i;
                }
                this.pairingsBox.setModel(new DefaultComboBoxModel<Integer>(pairIndices));
                if (pairIndices.length > 0) {
                    this.pairingsBox.setSelectedIndex(0);
                }
                this.update(true);
            } else if (source == this.pairingsBox) {
                this.update(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void update(boolean tableOnly) {
        RfRemoteTableModel model = (RfRemoteTableModel)this.remoteTable.getModel();
        model.setPairIndex((Integer)this.pairingsBox.getSelectedItem());
        model.fireTableDataChanged();
        if (!tableOnly) {
            RfRemote rfRemote = (RfRemote)this.remotesBox.getSelectedItem();
            List<RfRemote> list = this.owner.getRfRemotesList();
            RfRemote[] rfRemotes = list.toArray(new RfRemote[0]);
            this.remotesBox.setModel(new DefaultComboBoxModel<RfRemote>(rfRemotes));
            if (list.contains(rfRemote)) {
                this.remotesBox.setSelectedItem(rfRemote);
            } else if (list.size() > 0) {
                this.remotesBox.setSelectedIndex(0);
            } else {
                this.remotesBox.setSelectedIndex(-1);
            }
        }
    }

    private void setData(RfRemote rfRemote) {
        RfRemoteTableModel model = (RfRemoteTableModel)this.remoteTable.getModel();
        model.setRfRemote(rfRemote);
    }
}

