/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.rf.Mpdu;
import com.hifiremote.jp1.rf.Npdu;
import com.hifiremote.jp1.rf.Rf4ceAuthenticator;
import com.hifiremote.jp1.rf.RfCapturePanel;
import com.hifiremote.jp1.rf.RfEditorPanel;
import com.hifiremote.jp1.rf.RfRemote;
import com.hifiremote.jp1.rf.RfRemotePanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class RfTools
extends JP1Frame
implements ActionListener {
    private static final int PSDENTRYSIZE = 151;
    private RMIRSetup owner;
    private List<RfRemote> rfRemotesList = null;
    private JToolBar toolBar = null;
    private RFAction openAction = null;
    private JMenuItem exitItem = null;
    private JMenuItem deleteRegItem = null;
    private JMenuItem renameRegItem = null;
    private RfCapturePanel capturePanel = null;
    private RfRemotePanel remotePanel = null;

    private void savePreferences() throws Exception {
        int state = this.getExtendedState();
        if (state != 0) {
            this.setExtendedState(0);
        }
        preferences.setRFBounds(this.getBounds());
    }

    public RfTools(RMIRSetup RMIRSetup2) {
        super("RF Tools", properties);
        this.owner = RMIRSetup2;
        System.err.println("RfTools opening");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent event) {
                boolean doDispose = true;
                try {
                    System.err.println("RfTools.windowClosing() entered");
                    RfTools.this.savePreferences();
                }
                catch (Exception e) {
                    System.err.println("RfTools.windowClosing() caught an exception!");
                    e.printStackTrace(System.err);
                }
                finally {
                    if (doDispose) {
                        RfTools.this.nullify();
                        RfTools.this.dispose();
                    }
                }
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
        this.createMenus();
        this.createToolbar();
        this.setRfRemotesList();
        RfEditorPanel editorPanel = new RfEditorPanel(this);
        this.capturePanel = editorPanel.getCapturePanel();
        this.remotePanel = editorPanel.getRemotePanel();
        this.add((Component)editorPanel, "Center");
        this.pack();
        Rectangle bounds = preferences.getRFBounds();
        if (bounds != null) {
            this.setBounds(bounds);
        }
        this.setVisible(true);
    }

    public List<RfRemote> getRfRemotesList() {
        return this.rfRemotesList;
    }

    public List<RfRemote> setRfRemotesList() {
        this.rfRemotesList = new ArrayList<RfRemote>();
        String temp = null;
        for (int ndx : RfTools.getIndexMap().values()) {
            RfRemote rfRemote = new RfRemote();
            rfRemote.name = properties.getProperty("RfRemote." + ndx + ".name");
            temp = properties.getProperty("RfRemote." + ndx + ".extAddr");
            if (temp != null) {
                rfRemote.extAddr = new Hex(temp);
            }
            if ((temp = properties.getProperty("RfRemote." + ndx + ".data")) != null) {
                rfRemote.importRfData(temp, Rf4ceAuthenticator.Source.CONTROLLER, 0);
            }
            int n = 0;
            while ((temp = properties.getProperty("RfRemote." + ndx + ".pair." + n)) != null) {
                rfRemote.pairings.add(new RfRemote.Pairing(temp));
                String extra = properties.getProperty("RfRemote." + ndx + ".extra." + n);
                if (extra != null) {
                    rfRemote.importRfData(extra, Rf4ceAuthenticator.Source.TARGET, n);
                }
                ++n;
            }
            this.rfRemotesList.add(rfRemote);
            ++ndx;
        }
        return this.rfRemotesList;
    }

    private void createMenus() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.openAction = new RFAction("Open...", "OPEN", RMIRSetup.createIcon("RMOpen24"), "Open a file", 79);
        menu.add(this.openAction).setIcon(null);
        menu.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setMnemonic(88);
        this.exitItem.addActionListener(this);
        menu.add(this.exitItem);
        menu = new JMenu("RFRemote");
        menu.setMnemonic(82);
        menuBar.add(menu);
        this.renameRegItem = new JMenuItem("Rename RF Remote");
        this.renameRegItem.setMnemonic(78);
        this.renameRegItem.addActionListener(this);
        this.renameRegItem.setToolTipText("Rename a registered RF Remote");
        menu.add(this.renameRegItem);
        this.deleteRegItem = new JMenuItem("Delete registration");
        this.deleteRegItem.setMnemonic(68);
        this.deleteRegItem.addActionListener(this);
        this.deleteRegItem.setToolTipText("Delete the registration of an RF Remote");
        menu.add(this.deleteRegItem);
    }

    private void createToolbar() {
        this.toolBar.add(this.openAction);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.exitItem) {
                this.dispatchEvent(new WindowEvent(this, 201));
            } else if (source == this.deleteRegItem) {
                String message = "Please select an RF Remote to delete";
                String title = "Delete registration";
                RfRemote rfRemote = (RfRemote)JOptionPane.showInputDialog(this, message, title, 3, null, this.rfRemotesList.toArray(new RfRemote[0]), this.rfRemotesList.get(0));
                if (rfRemote == null) {
                    return;
                }
                int index = RfTools.getIndexMap().get(rfRemote.name);
                properties.remove("RfRemote." + index + ".name");
                properties.remove("RfRemote." + index + ".extAddr");
                properties.remove("RfRemote." + index + ".data");
                int n = 0;
                while (properties.remove("RfRemote." + index + ".pair." + n) != null) {
                    properties.remove("RfRemote." + index + ".extra." + n++);
                }
                List<RfRemote> list = this.getRfRemotesList();
                list.remove(rfRemote);
                for (Npdu.NSPrimitive prim : this.capturePanel.getData()) {
                    if (!prim.rfRemote.name.equals(rfRemote.name)) continue;
                    prim.rfRemote = null;
                }
                Rf4ceAuthenticator authenticator = new Rf4ceAuthenticator(list, this);
                for (Npdu.NSPrimitive prim : this.capturePanel.getData()) {
                    prim.process(authenticator);
                }
                this.remotePanel.update(false);
                this.capturePanel.update();
                message = "RF Remote " + rfRemote.name + " has been deleted.";
                JOptionPane.showMessageDialog(this, message, title, 1);
            } else if (source == this.renameRegItem) {
                String message = "Please select an RF Remote to rename";
                String title = "Rename RF Remote";
                RfRemote rfRemote = (RfRemote)JOptionPane.showInputDialog(this, message, title, 3, null, this.rfRemotesList.toArray(new RfRemote[0]), this.rfRemotesList.get(0));
                if (rfRemote == null) {
                    return;
                }
                int index = RfTools.getIndexMap().get(rfRemote.name);
                message = "Please enter a new name for RF Remote " + rfRemote.name + ".";
                String name = JOptionPane.showInputDialog(this, message, title, 3);
                if (name == null) {
                    return;
                }
                properties.put("RfRemote." + index + ".name", name);
                rfRemote.name = name;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPSDfile(File file) {
        if (file == null) {
            return;
        }
        System.err.println("Reading PSD file");
        int len = (int)file.length();
        System.err.println("File size: " + len);
        byte[] psdPacket = new byte[151];
        int packetCount = len / 151;
        LinkedHashMap<String, Npdu.NSPrimitive> map = new LinkedHashMap<String, Npdu.NSPrimitive>();
        Rf4ceAuthenticator authenticator = new Rf4ceAuthenticator(this.rfRemotesList, this);
        try (InputStream input = null;){
            input = new BufferedInputStream(new FileInputStream(file));
            for (int i = 0; i < packetCount; ++i) {
                int loopBytesRead = 0;
                while (loopBytesRead < 151) {
                    int bytesRemaining = 151 - loopBytesRead;
                    int bytesRead = input.read(psdPacket, loopBytesRead, bytesRemaining);
                    if (bytesRead <= 0) continue;
                    loopBytesRead += bytesRead;
                }
                int payloadLen = psdPacket[13] + (psdPacket[14] << 8);
                Hex payload = new Hex(psdPacket).subHex(15, payloadLen);
                short mpduLen = payload.getData()[0];
                if (payloadLen != mpduLen + 1) {
                    System.err.println("Inconsistent MPDU length, file read aborting");
                    return;
                }
                Mpdu mpdu = new Mpdu(payload, 1);
                Mpdu.MSPrimitive msPrim = mpdu.parse();
                Npdu npdu = msPrim.npdu;
                if (npdu == null) continue;
                String frameCtr = RfTools.getAddrString(npdu.subHex(1, 4));
                if (map.containsKey(frameCtr)) {
                    ++((Npdu.NSPrimitive)map.get((Object)frameCtr)).rptCount;
                    continue;
                }
                Npdu.NSPrimitive nsPrim = npdu.parse();
                if (!nsPrim.valid) {
                    System.err.println("Skipping malformed NPDU: " + npdu);
                    continue;
                }
                map.put(frameCtr, nsPrim);
                nsPrim.addrData = msPrim.addrData;
                nsPrim.process(authenticator);
                this.capturePanel.getData().add(nsPrim);
                RfRemote rfRemote = authenticator.getRfRemote();
                if (rfRemote == null || !rfRemote.changed) continue;
                if (authenticator.getPairNdx() < 0 || rfRemote.pairings.get(authenticator.getPairNdx()).getPairRef() == authenticator.getPairNdx()) {
                    this.updateRegistration(rfRemote);
                    continue;
                }
                String title = "RF Remote registration error";
                String addrStr = RfTools.getAddrString(rfRemote.extAddr);
                String msg = rfRemote.name == null ? "Registration of RF Remote with IEEE address " + addrStr + " failed." : "Change of registration for RF Remote named\n  " + rfRemote.name + "\nfailed.  The registration is retained unchanged.";
                JOptionPane.showMessageDialog(this, msg, title, 0);
                System.err.println("Pairing change failed");
                return;
            }
            this.capturePanel.update();
            this.remotePanel.update(false);
        }
        catch (FileNotFoundException ex) {
            System.err.println("File not found.");
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public void updateRegistration(RfRemote rfRemote) {
        String msg;
        String title;
        if (!rfRemote.changed) {
            return;
        }
        rfRemote.changed = false;
        String addrStr = rfRemote.extAddr != null ? RfTools.getAddrString(rfRemote.extAddr) : null;
        int ndx = 0;
        LinkedHashMap<String, Integer> indexMap = RfTools.getIndexMap();
        String name = rfRemote.name;
        String extAddrProperty = null;
        if (name != null && indexMap.get(name) != null) {
            ndx = indexMap.get(name);
            extAddrProperty = properties.getProperty("RfRemote." + ndx + ".extAddr");
        } else {
            this.rfRemotesList.add(rfRemote);
            ndx = 1;
            while (indexMap.values().contains(ndx)) {
                ++ndx;
            }
        }
        if (name == null) {
            title = "Registration of RF Remote";
            msg = "Loading this file has created a pairing entry for an unregistered\nRF Remote with IEEE address " + addrStr + ".  To register this\nRF Remote in RMIR so that its data signals can be decrypted, please\nenter a name for it in the box below.";
            String reply = "";
            while (reply != null && reply.trim().isEmpty()) {
                reply = JOptionPane.showInputDialog(this, msg, title, -1);
            }
            if (reply == null) {
                msg = "Registration aborted.";
                JOptionPane.showMessageDialog(this, msg, title, 2);
                return;
            }
            rfRemote.name = reply.trim();
        } else if (addrStr != null && extAddrProperty != null) {
            title = "Update of RF Remote registration";
            msg = "The pairings of RF Remote named\n  " + rfRemote.name + "\nhave been updated successfully.";
            JOptionPane.showMessageDialog(this, msg, title, 2);
        } else if (addrStr != null) {
            title = "Completion of provisional registration";
            msg = "Registration of RF Remote named " + name + " has been completed.\nIts IEEE address is " + addrStr + ".";
            JOptionPane.showMessageDialog(this, msg, title, 1);
        }
        properties.put("RfRemote." + ndx + ".name", rfRemote.name);
        if (rfRemote.extAddr != null) {
            properties.put("RfRemote." + ndx + ".extAddr", rfRemote.extAddr.toString());
        }
        properties.put("RfRemote." + ndx + ".data", rfRemote.getRfData(Rf4ceAuthenticator.Source.CONTROLLER, 0));
        for (int i = 0; i < rfRemote.pairings.size(); ++i) {
            properties.put("RfRemote." + ndx + ".pair." + i, rfRemote.pairings.get(i).getTableString());
            String extra = rfRemote.getRfData(Rf4ceAuthenticator.Source.TARGET, i);
            if (extra == null) continue;
            properties.put("RfRemote." + ndx + ".extra." + i, rfRemote.getRfData(Rf4ceAuthenticator.Source.TARGET, i));
        }
        System.err.println("Pairing change succeeded");
        System.err.println("Remote data: " + rfRemote.getRfData(Rf4ceAuthenticator.Source.CONTROLLER, 0));
        this.capturePanel.update();
        this.remotePanel.update(false);
    }

    public static LinkedHashMap<String, Integer> getIndexMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (String key : properties.stringPropertyNames()) {
            String name;
            if (!key.startsWith("RfRemote.")) continue;
            String s = key.substring(9);
            s = s.substring(0, s.indexOf(46));
            int index = new Integer(s);
            if (map.values().contains(index) || (name = properties.getProperty("RfRemote." + index + ".name")) == null) continue;
            map.put(name, index);
        }
        return map;
    }

    public static String getASCIIString(Hex hex) {
        return new String(hex.toByteArray());
    }

    public static String getAddrString(Hex addr) {
        if (addr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = addr.length();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%02X", addr.getData()[len - i - 1]));
        }
        return sb.toString();
    }

    public static Hex getAddrHex(String addr) {
        StringBuilder sb = new StringBuilder();
        int len = addr.length() / 2;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(addr.substring(2 * (len - i - 1), 2 * (len - i)));
        }
        return new Hex(sb.toString());
    }

    public static File getPSDFile(Component parent) {
        File path = preferences.getRFPath();
        File file = null;
        RMFileChooser chooser = new RMFileChooser(path);
        try {
            chooser.setAcceptAllFileFilterUsed(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        EndingFileFilter filter = null;
        filter = new EndingFileFilter("RF Packet Sniffer files (*.psd)", RMIRSetup.snifferEndings);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            if (!file.exists()) {
                JOptionPane.showMessageDialog(parent, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
            } else if (file.isDirectory()) {
                JOptionPane.showMessageDialog(parent, file.getName() + " is a directory.", "File doesn't exist.", 0);
            } else {
                preferences.setRFPath(file.getParentFile());
            }
        }
        return file;
    }

    private void nullify() {
        this.owner.setRfTools(null);
    }

    public class RFAction
    extends AbstractAction {
        public RFAction(String text, String action, ImageIcon icon, String description, Integer mnemonic) {
            super(text, icon);
            this.putValue("ActionCommandKey", action);
            this.putValue("ShortDescription", description);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String command = event.getActionCommand();
                if (command.equals("OPEN")) {
                    File file = RfTools.getPSDFile(RfTools.this);
                    try {
                        RfTools.this.openPSDfile(file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

