/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.settings;

import com.hifiremote.jp1.settings.Setting;
import com.hifiremote.jp1.settings.SettingFactory;
import java.io.IOException;
import java.io.OutputStream;

class Block {
    public static final int MAX_PAYLOAD_LENGTH = 488;
    private static final int KEY_OFFSET = 1;
    private static final int PAYLOAD_OFFSET = 17;
    private static final int PLAIN_DATA_LENGTH = 56;
    private SettingFactory settingFactory;
    private Setting setting;
    private Block nextBlock;
    private int payloadLength;
    private byte firstByte;
    private byte[] key;
    private byte[] payload;
    private byte checksum;
    private byte checksumComp;
    private byte[] rawData = null;
    private boolean modified;

    public Block(SettingFactory settingFactory, byte[] data, int len) {
        this.settingFactory = settingFactory;
        this.firstByte = data[0];
        this.key = new byte[16];
        System.arraycopy(data, 1, this.key, 0, this.key.length);
        this.payloadLength = Math.min(len - 19, 488);
        this.payload = new byte[this.payloadLength];
        System.arraycopy(data, 17, this.payload, 0, this.payloadLength);
        this.checksum = data[17 + this.payloadLength];
        this.checksumComp = data[17 + this.payloadLength + 1];
        if ((this.checksum & 0xFF) != (this.checksumComp & 0xFF ^ 0xFF)) {
            throw new RuntimeException("Checksum and checksum complement mismatch");
        }
        this.modified = false;
    }

    public void setNextBlock(Block block) {
        this.nextBlock = block;
    }

    public int getDataLength() {
        return this.payloadLength;
    }

    public void read(int offset, byte[] data) {
        this.read(offset, data, 0, data.length);
    }

    public void read(int offset, byte[] data, int outputOffset, int length) {
        int readLen = Math.min(length, this.payloadLength - offset);
        if (readLen <= 0) {
            this.readNext(offset - readLen, data, outputOffset, length);
        } else {
            this.ensureRawData();
            System.arraycopy(this.rawData, offset, data, outputOffset, readLen);
            if (readLen < length) {
                this.readNext(0, data, outputOffset + readLen, length - readLen);
            }
        }
    }

    private void readNext(int offset, byte[] data, int outputOffset, int length) {
        if (this.nextBlock == null) {
            throw new RuntimeException("Read position out of range");
        }
        this.nextBlock.read(offset, data, outputOffset, length);
    }

    public void write(int offset, byte[] data) {
        this.write(offset, data, 0, data.length);
    }

    public void write(int offset, byte[] data, int inputOffset, int length) {
        int writeLen = Math.min(length, this.payloadLength - offset);
        if (writeLen <= 0) {
            this.writeNext(offset - writeLen, data, inputOffset, length);
        } else {
            this.ensureRawData();
            System.arraycopy(data, inputOffset, this.rawData, offset, writeLen);
            this.modified = true;
            if (writeLen < length) {
                this.writeNext(0, data, inputOffset + writeLen, length - writeLen);
            }
        }
    }

    private void writeNext(int offset, byte[] data, int inputOffset, int length) {
        if (this.nextBlock == null) {
            throw new RuntimeException("Write position out of range");
        }
        this.nextBlock.write(offset, data, inputOffset, length);
    }

    private void ensureRawData() {
        if (this.rawData == null) {
            this.rawData = new byte[this.payloadLength];
            int offset = 0;
            byte[] enc = new byte[8];
            int[] tmp = new int[2];
            Setting setting = this.getSetting();
            while (offset < this.payloadLength) {
                System.arraycopy(this.payload, offset, enc, 0, 8);
                setting.byteArrayToIntArray(enc, tmp);
                setting.downgradeData(tmp);
                setting.intArrayToByteArray(tmp, enc);
                System.arraycopy(enc, 0, this.rawData, offset, 8);
                int copyLen = Math.min(56, this.payloadLength - (offset += 8));
                System.arraycopy(this.payload, offset, this.rawData, offset, copyLen);
                offset += copyLen;
            }
            int cs = 0;
            int i = 0;
            while (i < this.payloadLength) {
                cs ^= this.rawData[i];
                ++i;
            }
            if ((byte)(cs & 0xFF) != this.checksum) {
                throw new RuntimeException("Block checksum is incorrect");
            }
        }
    }

    public void save(OutputStream out) throws IOException {
        out.write(this.firstByte);
        out.write(this.key);
        if (this.modified) {
            this.checksum = 0;
            int i = 0;
            while (i < this.payloadLength) {
                this.checksum = (byte)(this.checksum ^ this.rawData[i]);
                ++i;
            }
            this.checksum = (byte)(this.checksum & 0xFF);
            this.checksumComp = (byte)(this.checksum ^ 0xFF);
            int offset = 0;
            byte[] enc = new byte[8];
            int[] tmp = new int[2];
            Setting setting = this.getSetting();
            while (offset < this.payloadLength) {
                System.arraycopy(this.rawData, offset, enc, 0, 8);
                setting.byteArrayToIntArray(enc, tmp);
                setting.upgradeData(tmp);
                setting.intArrayToByteArray(tmp, enc);
                System.arraycopy(enc, 0, this.payload, offset, 8);
                int copyLen = Math.min(56, this.payloadLength - (offset += 8));
                System.arraycopy(this.rawData, offset, this.payload, offset, copyLen);
                offset += copyLen;
            }
            this.modified = false;
        }
        out.write(this.payload);
        out.write(this.checksum);
        out.write(this.checksumComp);
        if (this.nextBlock != null) {
            int padding = 493 - this.payloadLength;
            int i = 0;
            while (i < padding) {
                out.write(0);
                ++i;
            }
        }
    }

    private Setting getSetting() {
        if (this.setting == null) {
            this.setting = this.settingFactory.getSetting(this.key);
        }
        return this.setting;
    }
}

