/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.settings;

public abstract class Setting {
    protected int[] key = new int[4];

    public Setting(byte[] key) {
        this.byteArrayToIntArray(key, this.key);
        int[] tmp = new int[2];
        int i = 0;
        while (i < 2) {
            System.arraycopy(this.key, i * 2, tmp, 0, 2);
            this.downgradeKey(tmp);
            System.arraycopy(tmp, 0, this.key, i * 2, 2);
            ++i;
        }
    }

    public void downgradeData(int[] data) {
        this.downgrade(data, this.key);
    }

    public void upgradeData(int[] data) {
        this.upgrade(data, this.key);
    }

    public void byteArrayToIntArray(byte[] in, int[] out) {
        int i = 0;
        while (i < out.length) {
            out[i] = 0;
            int j = 0;
            while (j < 4) {
                int n = i;
                out[n] = out[n] + ((in[i * 4 + j] & 0xFF) << j * 8);
                ++j;
            }
            ++i;
        }
    }

    public void intArrayToByteArray(int[] in, byte[] out) {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < 4) {
                out[i * 4 + j] = (byte)(in[i] >>> j * 8 & 0xFF);
                ++j;
            }
            ++i;
        }
    }

    protected abstract void downgradeKey(int[] var1);

    protected abstract void downgrade(int[] var1, int[] var2);

    protected abstract void upgrade(int[] var1, int[] var2);
}

