/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.settings;

import com.hifiremote.jp1.settings.Setting;
import java.util.HashMap;
import java.util.Map;

public class SettingFactory {
    private Class<? extends Setting> settingClass;
    private Map<String, Setting> instances;

    public SettingFactory(Class<? extends Setting> settingClass) {
        this.settingClass = settingClass;
        this.instances = new HashMap<String, Setting>();
    }

    public Setting getSetting(byte[] key) {
        String k = this.getKeyString(key);
        if (!this.instances.containsKey(k)) {
            try {
                this.instances.put(k, this.settingClass.getConstructor(byte[].class).newInstance(new Object[]{key}));
            }
            catch (Exception exc) {
                throw new RuntimeException("Problem with instantiating Setting class", exc);
            }
        }
        return this.instances.get(k);
    }

    private String getKeyString(byte[] key) {
        StringBuilder k = new StringBuilder(key.length);
        int i = 0;
        while (i < key.length) {
            k.append((char)key[i]);
            ++i;
        }
        return k.toString();
    }
}

