/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.settings;

import com.hifiremote.jp1.settings.Block;
import com.hifiremote.jp1.settings.SettingFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Settings {
    private List<Block> blocks;
    private int payloadSize = 0;
    private int flashOffset;

    public Settings(InputStream in, SettingFactory settingFactory) throws IOException {
        this(in, settingFactory, 0);
    }

    public Settings(InputStream in, SettingFactory settingFactory, int flashOffset) throws IOException {
        this.flashOffset = flashOffset;
        this.blocks = new ArrayList<Block>();
        byte[] buf = new byte[512];
        Block last = null;
        while (in.available() > 0) {
            int read = in.read(buf);
            Block block = null;
            try {
                block = new Block(settingFactory, buf, read);
            }
            catch (RuntimeException e) {
                this.blocks = null;
                return;
            }
            this.blocks.add(block);
            if (last != null) {
                last.setNextBlock(block);
            }
            last = block;
            this.payloadSize += block.getDataLength();
        }
    }

    public void setFlashOffset(int offset) {
        this.flashOffset = offset;
    }

    public int getFlashOffset() {
        return this.flashOffset;
    }

    public boolean isValid() {
        return this.blocks != null;
    }

    public void save(OutputStream out) throws IOException {
        for (Block block : this.blocks) {
            block.save(out);
        }
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    private Pair getBlockAndOffset(int offset, int length) {
        if ((offset -= this.flashOffset) < 0 || offset > this.payloadSize) {
            throw new RuntimeException("Offset is out of range");
        }
        if (offset + length > this.payloadSize) {
            throw new RuntimeException("Read/Write end is out of range");
        }
        int blockIdx = offset / 488;
        int blockOffset = offset % 488;
        return new Pair(blockIdx, blockOffset);
    }

    public void read(int offset, byte[] data) {
        Pair blockAndOffset = this.getBlockAndOffset(offset, data.length);
        this.blocks.get(blockAndOffset.getKey()).read(blockAndOffset.getValue(), data);
    }

    public void write(int offset, byte[] data) {
        Pair blockAndOffset = this.getBlockAndOffset(offset, data.length);
        this.blocks.get(blockAndOffset.getKey()).write(blockAndOffset.getValue(), data);
    }

    private class Pair {
        private int key = 0;
        private int value = 0;

        public Pair(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }
}

