/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class BandOtranslator
extends Translate {
    private int deviceOrCommand = 0;
    private static final int DEVICE = 0;
    private static final int DEVICE_V4 = 1;
    private static final int COMMAND = 2;
    private static final int COMMAND_V4 = 3;

    public BandOtranslator(String[] textParms) {
        super(textParms);
        this.deviceOrCommand = Integer.parseInt(textParms[0]);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int devLo = 0;
        if (this.deviceOrCommand == 0 || this.deviceOrCommand == 1) {
            int numHiBits = ((Number)parms[2].getValue()).intValue();
            if (numHiBits > 4 || numHiBits < 1) {
                numHiBits = 1;
                parms[2].setValue(numHiBits);
            }
            BandOtranslator.insert(hexData, 0, 8, numHiBits);
            int devHi = ((Number)parms[0].getValue()).intValue();
            int temp = (devHi &= (1 << numHiBits) - 1) << 8 - numHiBits;
            BandOtranslator.insert(hexData, 8 + this.deviceOrCommand * 8, 8, temp);
            parms[0].setValue(devHi);
            devLo = ((Number)parms[1].getValue()).intValue();
            BandOtranslator.insert(hexData, 16 + this.deviceOrCommand * 8, 8, devLo);
            if (this.deviceOrCommand == 1) {
                int rptMask = ((Number)parms[3].getValue()).intValue() << 5;
                BandOtranslator.insert(hexData, 8, 8, rptMask);
            }
        } else if (this.deviceOrCommand == 2 || this.deviceOrCommand == 3) {
            boolean isOdd = false;
            int obc = ((Number)parms[0].getValue()).intValue();
            int temp = (obc ^ obc >> 1) & 0xFF;
            devLo = ((Number)devParms[1].getValueOrDefault()).intValue();
            if ((devLo & 1) == 1) {
                temp |= 0x80;
                isOdd = true;
            }
            BandOtranslator.insert(hexData, 0, 8, temp);
            if (this.deviceOrCommand == 2) {
                int obc2 = ((Number)parms[1].getValue()).intValue();
                temp = obc2 ^ obc2 >> 1;
                if (isOdd) {
                    temp |= 0x80;
                }
                BandOtranslator.insert(hexData, 8, 8, temp);
            }
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        if (this.deviceOrCommand == 0 || this.deviceOrCommand == 1) {
            int numHiBits = BandOtranslator.extract(hexData, 0, 8);
            if (numHiBits > 4 || numHiBits < 1) {
                numHiBits = 1;
            }
            parms[2] = new Value(new Integer(numHiBits));
            int devHi = BandOtranslator.extract(hexData, 8 + this.deviceOrCommand * 8, 8) >> 8 - numHiBits;
            parms[0].setValue(devHi &= (1 << numHiBits) - 1);
            int devLo = BandOtranslator.extract(hexData, 16 + this.deviceOrCommand * 8, 8);
            parms[1] = new Value(new Integer(devLo));
            if (this.deviceOrCommand == 1) {
                int rptMask = BandOtranslator.extract(hexData, 8, 8) >> 5;
                parms[3] = new Value(new Integer(rptMask));
            }
        } else if (this.deviceOrCommand == 2 || this.deviceOrCommand == 3) {
            boolean isOdd = false;
            int temp = BandOtranslator.extract(hexData, 0, 8);
            int devLo = ((Number)devParms[1].getValueOrDefault()).intValue();
            isOdd = (devLo & 1) == 1;
            int obc = this.hexToBandO(temp, isOdd);
            parms[0] = new Value(new Integer(obc));
            if (this.deviceOrCommand == 2) {
                temp = BandOtranslator.extract(hexData, 8, 8);
                int obc2 = this.hexToBandO(temp, isOdd);
                parms[1] = new Value(new Integer(obc2));
            }
        }
    }

    int hexToBandO(int hexData, boolean isOdd) {
        int temp;
        int n = temp = isOdd ? 255 : 0;
        if ((hexData & 0x80) == 128) {
            temp ^= 0xFF;
        }
        if ((hexData & 0x40) == 64) {
            temp ^= 0x7F;
        }
        if ((hexData & 0x20) == 32) {
            temp ^= 0x3F;
        }
        if ((hexData & 0x10) == 16) {
            temp ^= 0x1F;
        }
        if ((hexData & 8) == 8) {
            temp ^= 0xF;
        }
        if ((hexData & 4) == 4) {
            temp ^= 7;
        }
        if ((hexData & 2) == 2) {
            temp ^= 3;
        }
        if ((hexData & 1) == 1) {
            temp ^= 1;
        }
        return temp;
    }
}

