/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class BitDoubler
extends Translate {
    private int parmIndex = 0;
    private int bits = 0;
    private int offset = 0;

    public BitDoubler(String[] textParms) {
        super(textParms);
        this.parmIndex = Integer.parseInt(textParms[0]);
        this.bits = Integer.parseInt(textParms[1]);
        this.offset = Integer.parseInt(textParms[2]);
    }

    private int doubleIt(int value) {
        int doubled = 0;
        int test = 1;
        int zero = 1;
        int one = 2;
        for (int bit = 0; bit < this.bits; ++bit) {
            doubled = (value & test) == 0 ? (doubled |= zero) : (doubled |= one);
            test <<= 1;
            zero <<= 2;
            one <<= 2;
        }
        return doubled;
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int value = ((Number)parms[this.parmIndex].getValue()).intValue();
        int doubled = this.doubleIt(value);
        BitDoubler.insert(hexData, this.offset, this.bits * 2, doubled);
    }

    private int halveIt(int value) {
        int test = 3;
        int rc = 0;
        int one = 1;
        for (int bit = 0; bit < this.bits; ++bit) {
            int val = value & test;
            if (val == 2) {
                rc |= one;
            } else if (val == 0 || val == 3) {
                System.err.println("Error in halveIt: can't halve " + val);
            }
            value >>= 2;
            one <<= 1;
        }
        return rc;
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        int doubled = BitDoubler.extract(hexData, this.offset, this.bits * 2);
        int halved = this.halveIt(doubled);
        parms[this.parmIndex] = new Value(new Integer(halved));
    }
}

