/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class BitExpander
extends Translate {
    private int devCmdIndex = 0;
    private int numChunksToConvert = 0;
    private int dstMsbOffset = 0;
    private int srcLsbOffset = 0;
    private int srcBitsPerChunk = 0;
    private int dstBitsPerChunk = 0;
    private boolean lsb = false;
    private int[] chunkDefs;

    public BitExpander(String[] textParms) {
        super(textParms);
        int numChunkDefs;
        int i;
        String[] nonLsbParms = new String[textParms.length];
        int ParmIndex = 0;
        for (i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            if (text.equalsIgnoreCase("lsb")) {
                this.lsb = true;
                continue;
            }
            nonLsbParms[ParmIndex] = text;
            ++ParmIndex;
        }
        this.devCmdIndex = Integer.parseInt(nonLsbParms[0]);
        this.numChunksToConvert = Integer.parseInt(nonLsbParms[1]);
        this.dstMsbOffset = Integer.parseInt(nonLsbParms[2]);
        this.srcLsbOffset = Integer.parseInt(nonLsbParms[3]);
        this.dstBitsPerChunk = Integer.parseInt(nonLsbParms[4]);
        for (i = numChunkDefs = ParmIndex - 5; i > 1; i >>= 1) {
            ++this.srcBitsPerChunk;
        }
        this.chunkDefs = new int[numChunkDefs];
        for (i = 0; i < numChunkDefs; ++i) {
            this.chunkDefs[i] = Integer.parseInt(nonLsbParms[i + 5], 16);
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int totalXbits = 0;
        int mask = (1 << this.srcBitsPerChunk) - 1;
        int value = ((Number)parms[this.devCmdIndex].getValue()).intValue();
        int w = value >> this.srcLsbOffset;
        if (this.lsb) {
            w = BitExpander.reverse(w, this.numChunksToConvert * this.srcBitsPerChunk);
        }
        for (int i = this.numChunksToConvert - 1; i > -1; --i) {
            int aChunk = w >> i * this.srcBitsPerChunk;
            int hex = this.chunkDefs[aChunk & mask];
            BitExpander.insert(hexData, this.dstMsbOffset + totalXbits, this.dstBitsPerChunk, hex);
            totalXbits += this.dstBitsPerChunk;
        }
    }

    private int indexOfXbits(int Xchunk) {
        int top = 1 << this.srcBitsPerChunk;
        for (int i = 0; i < top; ++i) {
            if (this.chunkDefs[i] != Xchunk) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        int i;
        int w = 0;
        int mask = (1 << this.dstBitsPerChunk) - 1;
        int theXbits = BitExpander.extract(hexData, this.dstMsbOffset, this.dstBitsPerChunk * this.numChunksToConvert);
        for (i = 0; i < this.numChunksToConvert; ++i) {
            int Xchunk = theXbits >> i * this.dstBitsPerChunk;
            int uncoded = this.indexOfXbits(Xchunk & mask);
            if (uncoded < 0) {
                System.err.println("BitExpander.out() can't decode " + Xchunk);
                return;
            }
            w |= uncoded << i * this.srcBitsPerChunk;
        }
        i = this.numChunksToConvert * this.srcBitsPerChunk;
        if (this.lsb) {
            w = BitExpander.reverse(w, i);
        }
        parms[this.devCmdIndex] = BitExpander.insert(parms[this.devCmdIndex], this.srcLsbOffset, i, w);
    }
}

