/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class FieldCopier
extends Translate {
    private boolean comp = false;
    private boolean lsb = false;
    private int srcOffset;
    private int destOffset;
    private int bits;
    private static final int srcOffsetIndex = 0;
    private static final int destOffsetIndex = 1;
    private static final int bitsIndex = 2;

    public FieldCopier(String[] textParms) {
        super(textParms);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            if (text.equalsIgnoreCase("lsb")) {
                this.lsb = true;
                continue;
            }
            if (text.equalsIgnoreCase("comp")) {
                this.comp = true;
                continue;
            }
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.srcOffset = val;
                    break;
                }
                case 1: {
                    this.destOffset = val;
                    break;
                }
                case 2: {
                    this.bits = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void in(Value[] parms, Hex hex, DeviceParameter[] devParms, int onlyIndex) {
        int val = FieldCopier.extract(hex, this.srcOffset, this.bits);
        if (this.lsb) {
            val = FieldCopier.reverse(val, this.bits);
        }
        if (this.comp) {
            val = FieldCopier.complement(val, this.bits);
        }
        FieldCopier.insert(hex, this.destOffset, this.bits, val);
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
    }
}

