/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class GrundigXlator
extends Translate {
    private int parmIndex = 0;
    private int bits = 0;
    private int offset = 0;

    public GrundigXlator(String[] textParms) {
        super(textParms);
        this.parmIndex = Integer.parseInt(textParms[0]);
        this.bits = Integer.parseInt(textParms[1]);
        this.offset = Integer.parseInt(textParms[2]);
    }

    private int DataToHex(int value) {
        int hex = 0;
        int test = 2;
        for (int bit = 0; bit < this.bits; bit += 2) {
            hex |= (value & test >> 1) << 1 | (value & test) >> 1 ^ value & test >> 1;
            test <<= 2;
        }
        return hex;
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int value = ((Number)parms[this.parmIndex].getValue()).intValue();
        int bitsOut = this.bits;
        if ((this.bits & 1) == 1) {
            ++bitsOut;
            value = value << 1 | hexData.getData()[0] >> 1 & 1;
        }
        int hex = this.DataToHex(value);
        GrundigXlator.insert(hexData, this.offset, bitsOut, hex);
    }

    private int HexToData(int value) {
        int data = 0;
        int test = 1;
        for (int bit = 0; bit < this.bits; bit += 2) {
            data |= (value & test << 1) >> 1 | (value & test) << 1 ^ value & test << 1;
            test <<= 2;
        }
        return data;
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        int bitsIn = this.bits + (this.bits & 1);
        int hex = GrundigXlator.extract(hexData, this.offset, bitsIn);
        int value = this.HexToData(hex);
        if ((this.bits & 1) == 1) {
            value >>= 1;
            int obcTop = ((Number)devParms[1].getValueOrDefault()).intValue();
            value += obcTop << this.bits;
        }
        parms[this.parmIndex] = GrundigXlator.insert(parms[this.parmIndex], 0, bitsIn, value);
    }
}

