/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class LutronTranslator
extends Translate {
    private static int[] encode = new int[]{1, 2, 7, 4, 13, 14, 11, 8};
    private int deviceOrCommand = 0;
    private int[] fd = new int[]{17, 18, 19, 20};
    private int[] OBCgrp = new int[]{33, 34, 35, 36};
    private static final int DEVICE = 0;
    private static final int COMMAND = 1;
    private static final int DEVICE_V4 = 2;
    private static final int COMMAND_V4 = 3;

    public LutronTranslator(String[] textParms) {
        super(textParms);
        this.deviceOrCommand = Integer.parseInt(textParms[0]);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int device = 0;
        if (this.deviceOrCommand == 0) {
            device = ((Number)parms[0].getValue()).intValue();
            int temp = (device & 0xE0) >> 5;
            LutronTranslator.insert(hexData, 8, 4, encode[temp]);
            temp = (device & 0x1C) >> 2;
            LutronTranslator.insert(hexData, 12, 4, encode[temp]);
        } else if (this.deviceOrCommand == 2) {
            device = ((Number)parms[0].getValue()).intValue();
            int temp = (device & 0xE0) >> 5;
            LutronTranslator.insert(hexData, 0, 4, encode[temp]);
            temp = (device & 0x1C) >> 2;
            LutronTranslator.insert(hexData, 4, 4, encode[temp]);
            this.calcV4FixedData(device, devParms);
            for (int f = 0; f < 4; ++f) {
                LutronTranslator.insert(hexData, f * 8, 4, this.fd[f] >> 4 & 0xF);
                LutronTranslator.insert(hexData, f * 8 + 4, 4, this.fd[f] & 0xF);
            }
        } else if (this.deviceOrCommand == 1) {
            device = ((Number)devParms[0].getValueOrDefault()).intValue();
            if (parms[1] != null && parms[1].getValue() != null) {
                device &= 0xFC;
                device |= ((Number)parms[1].getValue()).intValue();
            }
            int temp = device & 3;
            temp <<= 1;
            int obc = ((Number)parms[0].getValue()).intValue();
            LutronTranslator.insert(hexData, 0, 4, encode[temp |= (obc & 0x80) >> 7]);
            temp = (obc & 0x70) >> 4;
            LutronTranslator.insert(hexData, 4, 4, encode[temp]);
            temp = (obc & 0xE) >> 1;
            LutronTranslator.insert(hexData, 8, 4, encode[temp]);
            temp = this.calcLastOctalNibble(device, obc);
            LutronTranslator.insert(hexData, 12, 4, encode[temp]);
        } else {
            device = ((Number)devParms[0].getValueOrDefault()).intValue();
            this.calcV4FixedData(device, devParms);
            if (parms[0] != null && parms[0].getValue() != null) {
                int obc = ((Number)parms[0].getValue()).intValue();
                int temp = this.findFixedDataForGrp(obc >> 4);
                if (temp < 0) {
                    obc = ((Number)devParms[1].getValueOrDefault()).intValue() << 4;
                }
                LutronTranslator.insert(hexData, 0, 4, encode[(obc & 0xE) >> 1]);
                temp = this.calcLastOctalNibble(device, obc);
                LutronTranslator.insert(hexData, 4, 4, encode[temp]);
                temp = this.findFixedDataForGrp(obc >> 4);
                LutronTranslator.insert(hexData, 14, 2, temp - 1);
            }
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        if (this.deviceOrCommand == 0) {
            int temp = this.decode(LutronTranslator.extract(hexData, 8, 4));
            int device = temp << 5;
            temp = this.decode(LutronTranslator.extract(hexData, 12, 3));
            parms[0] = new Value(new Integer(device |= temp << 2));
        } else if (this.deviceOrCommand == 2) {
            int temp = this.decode(LutronTranslator.extract(hexData, 0, 4));
            int device = temp << 5;
            temp = this.decode(LutronTranslator.extract(hexData, 4, 4));
            device |= temp << 2;
            temp = this.decode(LutronTranslator.extract(hexData, 8, 4));
            parms[0] = new Value(new Integer(device |= temp >> 1));
            for (int p = 1; p < 4; ++p) {
                temp = this.decode(LutronTranslator.extract(hexData, p * 8, 4));
                int grp = (temp & 1) << 3;
                temp = this.decode(LutronTranslator.extract(hexData, p * 8 + 4, 4));
                parms[p] = new Value(new Integer(grp |= temp));
            }
        } else if (this.deviceOrCommand == 1) {
            int temp = this.decode(LutronTranslator.extract(hexData, 0, 4));
            int obc = (temp & 1) << 7;
            int device = temp >> 1;
            temp = this.decode(LutronTranslator.extract(hexData, 4, 4));
            obc |= temp << 4;
            temp = this.decode(LutronTranslator.extract(hexData, 8, 4));
            obc |= temp << 1;
            temp = this.decode(LutronTranslator.extract(hexData, 12, 4));
            parms[0] = new Value(new Integer(obc |= temp >> 2));
            parms[1] = new Value(new Integer(device));
        } else {
            int device = ((Number)devParms[0].getValueOrDefault()).intValue();
            this.calcV4FixedData(device, devParms);
            int fdIdx = LutronTranslator.extract(hexData, 14, 2) + 1;
            int obc = this.OBCgrp[fdIdx] << 4;
            int temp = LutronTranslator.extract(hexData, 0, 4);
            if (temp == 0) {
                temp = 1;
            }
            temp = this.decode(temp);
            obc |= temp << 1;
            temp = LutronTranslator.extract(hexData, 4, 4);
            if (temp == 0) {
                temp = 1;
            }
            temp = this.decode(temp);
            parms[0] = new Value(new Integer(obc |= (temp & 4) >> 2));
            temp = LutronTranslator.extract(hexData, 8, 2);
            parms[1] = new Value(new Integer(temp));
        }
    }

    private int decode(int val) {
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] != val) continue;
            return i;
        }
        System.err.println("LutronTranslator.decode( " + val + " ) failed!");
        return 0;
    }

    private void calcV4FixedData(int device, DeviceParameter[] devParms) {
        this.fd[0] = (encode[(device & 0xE0) >> 5] << 4) + encode[(device & 0x1C) >> 2];
        for (int p = 1; p < 4; ++p) {
            if (devParms[p] == null || devParms[p].getValueOrDefault() == null) continue;
            this.OBCgrp[p] = ((Number)devParms[p].getValueOrDefault()).intValue();
            int temp = ((device & 3) << 1) + (this.OBCgrp[p] >> 3 & 1);
            this.fd[p] = (encode[temp] << 4) + encode[this.OBCgrp[p] & 7];
        }
    }

    private int calcLastOctalNibble(int device, int obc) {
        int temp = device ^ obc;
        int checksum = 0;
        checksum ^= temp & 3;
        checksum ^= (temp >>= 2) & 3;
        checksum ^= (temp >>= 2) & 3;
        checksum ^= (temp >>= 2) & 3;
        temp = (obc & 1) << 2;
        return temp |= checksum;
    }

    private int findFixedDataForGrp(int grp) {
        int i;
        for (i = 1; i < 4 && this.OBCgrp[i] != grp; ++i) {
        }
        if (i < 4) {
            return i;
        }
        return -1;
    }
}

