/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class NEC005ATranslator
extends Translate {
    private int styleBits;

    public NEC005ATranslator(String[] textParms) {
        super(textParms);
        this.styleBits = Integer.parseInt(textParms[0], 16);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int specialRecHandling = -1;
        short[] hex = hexData.getData();
        hex[0] = (short)(0x20 | (short)this.styleBits);
        Number deviceNumber = (Number)parms[0].getUserValue();
        if (deviceNumber == null) {
            deviceNumber = new Integer(0);
        }
        hex[1] = (short)NEC005ATranslator.reverse(NEC005ATranslator.complement(deviceNumber.intValue()));
        Number subDevice = (Number)parms[1].getUserValue();
        if (subDevice == null) {
            hex[0] = (short)(hex[0] & 0xDF);
            hex[2] = 0;
        } else {
            hex[2] = (short)NEC005ATranslator.reverse(NEC005ATranslator.complement(subDevice.intValue()));
        }
        if ((this.styleBits & 0x10) == 0) {
            specialRecHandling = ((Number)parms[2].getValue()).intValue();
            if (specialRecHandling > 0) {
                if (subDevice == null) {
                    subDevice = new Integer(0);
                }
                hex[2] = (short)NEC005ATranslator.reverse(NEC005ATranslator.complement(subDevice.intValue()));
                hex[0] = (short)(hex[0] | 4);
                hex[0] = specialRecHandling == 1 ? (short)(hex[0] & 0xDF) : (short)(hex[0] | 0x20);
            }
            if (this.styleBits == 0) {
                Number NEC2onRepeatButton = (Number)parms[3].getValue();
                hex[0] = (short)(hex[0] | (short)NEC2onRepeatButton.intValue() << 3);
                Number twiceThenDittos = (Number)parms[4].getValue();
                hex[0] = (short)(hex[0] | (short)twiceThenDittos.intValue() << 1);
            }
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        short[] hex = hexData.getData();
        Integer deviceNumber = new Integer(NEC005ATranslator.byte2int(NEC005ATranslator.reverse(NEC005ATranslator.complement(hex[1]))));
        Integer subDevice = new Integer(NEC005ATranslator.byte2int(NEC005ATranslator.reverse(NEC005ATranslator.complement(hex[2]))));
        Integer controlBits = new Integer(hex[0]);
        boolean dev_subFormat = false;
        int specialRecHandling = 0;
        if ((controlBits & this.styleBits) != this.styleBits) {
            deviceNumber = null;
            subDevice = null;
        } else {
            boolean bl = dev_subFormat = (controlBits & 0x20) == 32;
            if ((controlBits & 0x10) == 0) {
                specialRecHandling = (controlBits & 4) >> 2;
                if (specialRecHandling == 1) {
                    specialRecHandling = dev_subFormat ? 2 : 1;
                }
                parms[2] = new Value(specialRecHandling, null);
                if ((controlBits & 0x11) == 0) {
                    parms[3] = new Value((controlBits & 8) >> 3, null);
                    parms[4] = new Value((controlBits & 2) >> 1, null);
                }
            }
        }
        parms[0] = new Value(deviceNumber, null);
        parms[1] = dev_subFormat || specialRecHandling == 1 ? new Value(subDevice, null) : new Value(null, null);
    }
}

