/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class NibbleSumChk
extends Translate {
    private int mask = 48896;
    private int destOffset = 4;
    private int seed = 0;
    private boolean comp = false;
    private static final int maskIndex = 0;
    private static final int destOffsetIndex = 1;
    private static final int seedIndex = 2;

    public NibbleSumChk(String[] textParms) {
        super(textParms);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            if (text.equalsIgnoreCase("comp")) {
                this.comp = true;
                continue;
            }
            switch (parmIndex) {
                case 0: {
                    this.mask = Integer.parseInt(text, 16);
                    break;
                }
                case 1: {
                    this.destOffset = Integer.parseInt(text);
                    break;
                }
                case 2: {
                    this.seed = Integer.parseInt(text);
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int v = this.seed;
        int s = 0;
        int andBit = 32768;
        for (int i = 0; i < 16; ++i) {
            if ((this.mask & andBit) == andBit) {
                v += NibbleSumChk.extract(hexData, s, 4);
            }
            s += 4;
            andBit /= 2;
        }
        if (this.comp) {
            v ^= 0xFFFFFFFF;
        }
        NibbleSumChk.insert(hexData, this.destOffset, 4, v &= 0xF);
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
    }
}

