/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class PanasonicMixComboTranslator
extends Translate {
    private static int bitLength = 6;

    public PanasonicMixComboTranslator(String[] textParms) {
        super(textParms);
    }

    private static int getDevice(int value) {
        int rc = -1;
        int mask = 1 << bitLength - 1;
        for (int i = 0; i < bitLength; ++i) {
            if ((value & mask) != 0) {
                rc = i;
                break;
            }
            mask >>= 1;
        }
        System.err.println("getDevice(" + Integer.toHexString(value) + ") = " + rc);
        return rc;
    }

    private static int getSubDevice(int value) {
        int rc = -1;
        int mask = 1;
        for (int i = bitLength; i >= 0; --i) {
            if ((value & mask) != 0) {
                rc = i - 1;
                break;
            }
            mask <<= 1;
        }
        System.err.println("getSubDevice(" + Integer.toHexString(value) + ") = " + rc);
        return rc - 1;
    }

    private int combineValues(int device, int subDevice) {
        if (subDevice <= device) {
            subDevice = device + 1;
        }
        int rc = 1 << bitLength - 1 - device;
        System.err.println("combineValues(" + device + "," + subDevice + ") = " + Integer.toHexString(rc |= 1 << bitLength - 1 - subDevice));
        return rc;
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int device = 0;
        int subDevice = 0;
        short byte2 = 0;
        System.err.println("in(), onlyIndex=" + onlyIndex);
        if (onlyIndex == 1) {
            device = ((Number)parms[1].getValue()).intValue();
            byte2 = hexData.getData()[1];
            subDevice = PanasonicMixComboTranslator.getSubDevice(byte2);
            int value = this.combineValues(device, subDevice);
            PanasonicMixComboTranslator.insert(hexData, 10, bitLength, value);
        } else if (onlyIndex == 2) {
            byte2 = hexData.getData()[1];
            device = PanasonicMixComboTranslator.getDevice(byte2);
            subDevice = ((Number)parms[2].getValue()).intValue() + 1;
            int value = this.combineValues(device, subDevice);
            PanasonicMixComboTranslator.insert(hexData, 10, bitLength, value);
        } else if (onlyIndex == -1) {
            if (parms[1] == null || parms[1].getValue() == null) {
                return;
            }
            if (parms[2] == null || parms[2].getValue() == null) {
                return;
            }
            device = ((Number)parms[1].getValue()).intValue();
            subDevice = ((Number)parms[2].getValue()).intValue() + 1;
            PanasonicMixComboTranslator.insert(hexData, 10, bitLength, this.combineValues(device, subDevice));
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        short byte2 = hex.getData()[1];
        System.err.println("out( " + Integer.toHexString(byte2) + " )");
        parms[1] = new Value(new Integer(PanasonicMixComboTranslator.getDevice(byte2)));
        parms[2] = new Value(new Integer(PanasonicMixComboTranslator.getSubDevice(byte2)));
    }
}

