/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class PanasonicMixTranslator
extends Translate {
    public PanasonicMixTranslator(String[] textParms) {
        super(textParms);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int iSub;
        int iDev;
        if (onlyIndex > 1) {
            return;
        }
        Value dev = parms[0];
        Value sub = parms[1];
        if (dev == null) {
            int v = hexData.getData()[1] & 0x3F;
            for (iDev = 6; iDev > 0 && v > 32 >> iDev; --iDev) {
            }
        } else {
            iDev = ((Number)dev.getValue()).intValue();
        }
        iDev = 32 >> iDev;
        if (sub == null) {
            int v = hexData.getData()[1] & 0x3F;
            for (iSub = 5; iSub > 0 && (v & 16 >> iSub) == 0; --iSub) {
            }
            if (v == 16 >> iSub) {
                iSub = 0;
            }
        } else {
            iSub = ((Number)sub.getValue()).intValue();
        }
        if (iSub != 0) {
            iDev |= 16 >> iSub;
        }
        PanasonicMixTranslator.insert(hexData, 10, 6, iDev);
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        int s;
        int d;
        int v = hex.getData()[1] & 0x3F;
        for (d = 0; d < 5 && v < 32 >> d; ++d) {
        }
        v -= 32 >> d;
        for (s = 4; s > 0 && v != 16 >> s; --s) {
        }
        parms[0] = new Value(new Integer(d), null);
        parms[1] = new Value(new Integer(s), null);
    }
}

