/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translator;

public class Pioneer3DevXlator
extends Translator {
    private static int devIndex = 0;
    private static int obcIndex = 1;
    private static int obc2Index = 2;

    public Pioneer3DevXlator(String[] textParms) {
        super(textParms);
    }

    private int getDevice(Hex hex) {
        int temp = Pioneer3DevXlator.extract(hex, 8, 3);
        if (temp == 4) {
            return 0;
        }
        if (temp == 2) {
            return 1;
        }
        return 2;
    }

    private int getDevice(Value[] parms) {
        if (parms[devIndex] == null || parms[devIndex].getValue() == null) {
            return 0;
        }
        return ((Number)parms[devIndex].getValue()).intValue();
    }

    private void setDevice(int device, Hex hex) {
        int temp = 1 << 2 - device;
        Pioneer3DevXlator.insert(hex, 8, 3, temp);
    }

    private int getObc(Hex hex) {
        return Pioneer3DevXlator.reverse(Pioneer3DevXlator.extract(hex, 0, 8));
    }

    private int getObc(Value[] parms) {
        return ((Number)parms[obcIndex].getValue()).intValue();
    }

    private void setObc(int obc, Hex hex) {
        Pioneer3DevXlator.insert(hex, 0, 8, Pioneer3DevXlator.reverse(obc));
    }

    private int adjust(int obc, int obc2) {
        if ((obc & 0x80) != 0) {
            obc2 += 128;
        }
        if ((obc & 0x40) == 0) {
            obc2 += 64;
        }
        return obc2;
    }

    private Integer getObc2(Hex hex) {
        int obc2 = Pioneer3DevXlator.reverse(Pioneer3DevXlator.extract(hex, 11, 5), 5);
        if (obc2 == 0) {
            return null;
        }
        int obc = this.getObc(hex);
        return new Integer(this.adjust(obc, obc2));
    }

    private Number getObc2(Value[] parms) {
        if (parms[obc2Index] == null || parms[obc2Index].getValue() == null) {
            return null;
        }
        return (Number)parms[obc2Index].getValue();
    }

    private void setObc2(Number obc2, Hex hex) {
        if (obc2 != null) {
            int val = obc2.intValue();
            Pioneer3DevXlator.insert(hex, 11, 5, Pioneer3DevXlator.reverse(val, 5));
            Integer temp = this.getObc2(hex);
            if (!(obc2.equals(temp) || val == 0 && temp == null)) {
                throw new IllegalArgumentException("OBC=" + this.getObc(hex) + " and OBC2=" + val + " can not be sent using Pioneer 3DEV. Use Pioneer 4DEV instead.");
            }
        } else {
            Pioneer3DevXlator.insert(hex, 11, 5, 0);
        }
    }

    @Override
    public void in(Value[] parms, Hex hex, DeviceParameter[] devParms, int onlyIndex) {
        boolean doAll;
        boolean bl = doAll = onlyIndex < 0;
        if (onlyIndex == devIndex || doAll) {
            this.setDevice(this.getDevice(parms), hex);
        }
        if (onlyIndex == obcIndex || doAll) {
            int obc = this.getObc(parms);
            this.setObc(obc, hex);
        }
        if (onlyIndex == obc2Index || doAll) {
            this.setObc2(this.getObc2(parms), hex);
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        parms[Pioneer3DevXlator.devIndex] = new Value(new Integer(this.getDevice(hex)));
        int obc = this.getObc(hex);
        parms[Pioneer3DevXlator.obcIndex] = new Value(new Integer(obc));
        Integer obc2 = this.getObc2(hex);
        parms[Pioneer3DevXlator.obc2Index] = new Value(obc2);
    }
}

