/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translator;

public class Pioneer4DevImporter
extends Translator {
    private int devIndex = 0;
    private int obc2Index = 1;

    public Pioneer4DevImporter(String[] textParms) {
        super(textParms);
    }

    public int setDeviceBit(int obc, int flag) {
        obc = flag != 0 ? (obc |= 0x20) : (obc &= 0xDF);
        return obc;
    }

    private void setHex(int obc1, int obc2, int device, short[] hex) {
        obc1 = this.setDeviceBit(obc1, device & 2);
        hex[0] = (short)Pioneer4DevImporter.reverse(obc1);
        obc2 = this.setDeviceBit(obc2, device & 1);
        hex[1] = (short)Pioneer4DevImporter.reverse(obc2);
    }

    private int getDevice(short[] hex) {
        int device = 0;
        if ((hex[0] & 4) > 0) {
            device += 2;
        }
        if ((hex[1] & 4) > 0) {
            ++device;
        }
        return device;
    }

    private int getDevice(Value[] parms) {
        int device = 0;
        if (parms[this.devIndex] != null && parms[this.devIndex].getValue() != null) {
            device = ((Number)parms[this.devIndex].getValue()).intValue() - 1;
        }
        return device;
    }

    private int getObc(short[] hex, int index) {
        return Pioneer4DevImporter.reverse(hex[index]) & 0xDF;
    }

    private int getObc(Value[] parms, int index, int value) {
        if (parms[index] != null && parms[index].getValue() != null) {
            System.err.println("parms[index].getValue() is a " + parms[index].getValue().getClass());
            value = ((Number)parms[index].getValue()).intValue();
        }
        return value;
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        short[] hex = hexData.getData();
        if (onlyIndex == 0) {
            int device = this.getDevice(parms);
            int obc1 = this.getObc(hex, 0);
            this.setHex(obc1, obc1, device, hex);
        } else if (onlyIndex == 1) {
            int device = this.getDevice(hex);
            int obc1 = this.getObc(hex, 0);
            int obc2 = this.getObc(parms, 1, obc1);
            this.setHex(obc1, obc2, device, hex);
        } else {
            return;
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
    }
}

