/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translator;

public class Pioneer4DevXlator
extends Translator {
    private int devIndex = 0;
    private int obcIndex = 0;
    private int obc2Index = 0;

    public Pioneer4DevXlator(String[] textParms) {
        super(textParms);
        this.devIndex = Integer.parseInt(textParms[0]);
        if (this.devIndex == 0) {
            this.obcIndex = 1;
            this.obc2Index = 2;
        } else if (this.devIndex == 1) {
            this.obcIndex = 0;
            this.obc2Index = 2;
        } else {
            this.obcIndex = 0;
            this.obc2Index = 1;
        }
    }

    public int setDeviceBit(int obc, int flag) {
        obc = flag != 0 ? (obc |= 0x20) : (obc &= 0xDF);
        return obc;
    }

    private void setHex(int obc1, int obc2, int device, short[] hex) {
        obc1 = this.setDeviceBit(obc1, device & 2);
        hex[0] = (short)Pioneer4DevXlator.reverse(obc1);
        obc2 = this.setDeviceBit(obc2, device & 1);
        hex[1] = (short)Pioneer4DevXlator.reverse(obc2);
    }

    private int getDevice(short[] hex) {
        int device = 0;
        if ((hex[0] & 4) > 0) {
            device += 2;
        }
        if ((hex[1] & 4) > 0) {
            ++device;
        }
        return device;
    }

    private int getDevice(Value[] parms) {
        int device = 0;
        if (parms[this.devIndex] != null && parms[this.devIndex].getValue() != null) {
            device = ((Number)parms[this.devIndex].getValue()).intValue();
        }
        return device;
    }

    private short getObc(short[] hex, int index) {
        return (short)(Pioneer4DevXlator.reverse(hex[index]) & 0xDF);
    }

    private short getObc(Value[] parms, int index, int value) {
        int i = index == 0 ? this.obcIndex : this.obc2Index;
        if (parms[i] != null && parms[i].getValue() != null) {
            System.err.println("parms[i].getValue() is a " + parms[i].getValue().getClass());
            value = ((Number)parms[i].getValue()).intValue();
        }
        return (short)value;
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        short[] hex = hexData.getData();
        if (onlyIndex == this.devIndex) {
            int device = this.getDevice(parms);
            short obc1 = this.getObc(hex, 0);
            short obc2 = this.getObc(hex, 1);
            this.setHex(obc1, obc2, device, hex);
        } else if (onlyIndex == this.obcIndex) {
            int device = this.getDevice(hex);
            short obc1 = this.getObc(parms, 0, 0);
            short oldObc = this.getObc(hex, 0);
            short obc2 = this.getObc(hex, 1);
            if (obc2 == oldObc) {
                obc2 = obc1;
            }
            this.setHex(obc1, obc2, device, hex);
        } else if (onlyIndex == this.obc2Index) {
            int device = this.getDevice(hex);
            short obc1 = this.getObc(hex, 0);
            short obc2 = this.getObc(parms, 1, obc1);
            this.setHex(obc1, obc2, device, hex);
        } else {
            System.err.println("onlyIndex=" + onlyIndex);
            int device = this.getDevice(parms);
            short obc1 = this.getObc(parms, 0, 0);
            short obc2 = this.getObc(parms, 1, obc1);
            this.setHex(obc1, obc2, device, hex);
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        short[] hex = hexData.getData();
        short obc1 = this.getObc(hex, 0);
        short obc2 = this.getObc(hex, 1);
        parms[this.devIndex] = new Value(new Integer(this.getDevice(hex)));
        Integer obcInt = new Integer(obc1);
        parms[this.obcIndex] = new Value(obcInt);
        parms[this.obc2Index] = obc2 != obc1 ? new Value(new Integer(obc2)) : new Value(null);
    }
}

