/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class PioneerMixTranslator
extends Translate {
    private int execVariant = 3;
    private int mask = 255;
    private int flag = 0;

    public PioneerMixTranslator(String[] textParms) {
        super(textParms);
        this.execVariant = textParms.length > 0 ? Integer.parseInt(textParms[0]) : 3;
        this.mask = this.execVariant == 5 ? 63 : 7;
    }

    @Override
    public void in(Value[] parms, Hex hex, DeviceParameter[] devParms, int onlyIndex) {
        int flag = PioneerMixTranslator.extract(hex, 10, 6);
        boolean doInsert = true;
        boolean hasPrefix = false;
        block6: for (int i = 0; i < parms.length; ++i) {
            if (onlyIndex != -1 && onlyIndex != i || parms[i] == null || parms[i].getValue() == null) continue;
            int val = ((Number)parms[i].getValue()).intValue();
            if (parms[0] != null && parms[0].getValue() != null) {
                hasPrefix = (((Number)parms[0].getValue()).intValue() & 1) == 1;
            }
            switch (i) {
                case 0: {
                    if (val == 0) {
                        flag &= 0xFE;
                        continue block6;
                    }
                    flag |= 1;
                    continue block6;
                }
                case 1: {
                    if (val == 0) {
                        flag &= 0xFE;
                        continue block6;
                    }
                    flag = flag & 0xF9 | val - 1 << 1;
                    continue block6;
                }
                case 2: {
                    if (this.execVariant == 3) {
                        if (val == 0) {
                            flag &= 0xFE;
                            continue block6;
                        }
                        flag |= 1;
                        continue block6;
                    }
                    if (this.execVariant == 4) {
                        if (val >= 4 || hasPrefix) continue block6;
                        flag = flag & 0xF8 | val << 1;
                        continue block6;
                    }
                    if (this.execVariant != 5) continue block6;
                    if (val < 4 && !hasPrefix) {
                        flag = flag & 0xF8 | val << 1;
                        continue block6;
                    }
                    if (val == 5) {
                        flag &= 0xDF;
                        continue block6;
                    }
                    if (val <= 0) continue block6;
                    flag = flag & 0xE7 | val - 1 << 3 | 0x21;
                    continue block6;
                }
                case 3: {
                    if (onlyIndex != 3) continue block6;
                    doInsert = false;
                }
            }
        }
        if (doInsert) {
            PioneerMixTranslator.insert(hex, 10, 6, flag & this.mask);
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        int val = PioneerMixTranslator.extract(hex, 10, 6);
        int val21 = val >> 1 & 3;
        int val43 = val >> 3 & 3;
        Integer zero = new Integer(0);
        Integer one = new Integer(1);
        if ((val & 1) == 0) {
            parms[0] = new Value(zero, null);
            parms[1] = new Value(zero, null);
            parms[2] = this.execVariant == 3 ? new Value(zero, null) : new Value(new Integer(val21), null);
        } else {
            parms[0] = new Value(one, null);
            if (this.execVariant == 3) {
                parms[1] = new Value(new Integer(val21 + 1), null);
                parms[2] = new Value(one, null);
            } else {
                parms[1] = new Value(new Integer(val21 + 1), null);
                parms[2] = (val & 0x20) == 0 ? new Value(new Integer(5), null) : new Value(new Integer(val43 + 1), null);
            }
        }
    }
}

