/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class RC5_5xComboTranslator
extends Translate {
    private static final int TYPE = 0;
    private static final int OBC = 1;
    private static final int RC5_DEVICE = 2;
    private static final int RC5X_DEVICE = 3;
    private static final int RC5X_SUB_DEVICE = 4;

    public RC5_5xComboTranslator(String[] textParms) {
        super(textParms);
    }

    public Number getValue(Value value) {
        if (value == null) {
            return null;
        }
        return (Number)value.getValue();
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int type;
        Number n = this.getValue(parms[0]);
        if (n != null) {
            type = n.intValue();
            RC5_5xComboTranslator.insert(hexData, 15, 1, type);
        } else {
            type = RC5_5xComboTranslator.extract(hexData, 15, 1);
        }
        if (type == 0) {
            int i;
            RC5_5xComboTranslator.insert(hexData, 0, 1, 0);
            RC5_5xComboTranslator.insert(hexData, 2, 1, 0);
            RC5_5xComboTranslator.insert(hexData, 14, 1, 0);
            n = this.getValue(parms[2]);
            if (n != null) {
                i = n.intValue();
                RC5_5xComboTranslator.insert(hexData, 3, 5, RC5_5xComboTranslator.complement(i, 5));
            }
            if ((n = this.getValue(parms[1])) != null) {
                int obc = n.intValue();
                i = obc & 0x3F;
                RC5_5xComboTranslator.insert(hexData, 8, 6, RC5_5xComboTranslator.complement(i, 6));
                i = obc >> 6;
                RC5_5xComboTranslator.insert(hexData, 1, 1, i);
            }
        } else {
            int i;
            RC5_5xComboTranslator.insert(hexData, 12, 1, 0);
            n = this.getValue(parms[3]);
            if (n != null) {
                i = n.intValue();
                RC5_5xComboTranslator.insert(hexData, 13, 2, i);
            }
            if ((n = this.getValue(parms[4])) != null) {
                i = n.intValue();
                RC5_5xComboTranslator.insert(hexData, 0, 6, RC5_5xComboTranslator.complement(i, 6));
            }
            if ((n = this.getValue(parms[1])) != null) {
                i = n.intValue();
                RC5_5xComboTranslator.insert(hexData, 6, 6, RC5_5xComboTranslator.complement(i, 6));
            }
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        int type = RC5_5xComboTranslator.extract(hexData, 15, 1);
        parms[0] = new Value(type);
        if (type == 0) {
            parms[2] = new Value(RC5_5xComboTranslator.complement(RC5_5xComboTranslator.extract(hexData, 3, 5), 5));
            int obc = RC5_5xComboTranslator.complement(RC5_5xComboTranslator.extract(hexData, 8, 6), 6);
            if (RC5_5xComboTranslator.extract(hexData, 1, 1) == 1) {
                obc += 64;
            }
            parms[1] = new Value(obc);
            parms[3] = new Value(null);
            parms[4] = new Value(null);
        } else {
            parms[2] = new Value(null);
            int device = RC5_5xComboTranslator.extract(hexData, 13, 2);
            parms[3] = new Value(device);
            int subDevice = RC5_5xComboTranslator.complement(RC5_5xComboTranslator.extract(hexData, 0, 6), 6);
            int flag = (Integer)devParms[device * 2 + 1].getValueOrDefault();
            if (flag != 0) {
                subDevice += 64;
            }
            parms[4] = new Value(subDevice);
            parms[1] = new Value(RC5_5xComboTranslator.complement(RC5_5xComboTranslator.extract(hexData, 6, 6), 6));
        }
    }
}

