/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class Rc5FlagTranslator
extends Translate {
    protected int devOffset = 0;

    public Rc5FlagTranslator(String[] textParms) {
        super(textParms);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.devOffset = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        short[] hex = hexData.getData();
        int numFlags = hex.length - this.devOffset;
        int flag = 0;
        for (int i = 0; i < numFlags; ++i) {
            int parmIndex = 2 * i + this.devOffset;
            Object val = parms[parmIndex].getUserValue();
            int thisFlag = ((Number)parms[parmIndex + 1].getValue()).intValue();
            if (i != 0 && val == null) {
                thisFlag = 1 - flag;
            }
            hex[i + this.devOffset] = (short)(hex[i + this.devOffset] & 0xBF | thisFlag * 64);
            flag = thisFlag;
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        short[] hex = hexData.getData();
        Value one = new Value(new Integer(1));
        Value zero = new Value(new Integer(0));
        for (int i = 0; i < hex.length - this.devOffset; ++i) {
            int flag = hex[i + this.devOffset] & 0x40;
            int parmIndex = 2 * i + this.devOffset + 1;
            parms[parmIndex] = flag == 0 ? zero : one;
        }
    }
}

