/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class Rc5Translator
extends Translate {
    protected int devOffset = 0;
    protected int devCount = 3;

    public Rc5Translator(String[] textParms) {
        super(textParms);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.devOffset = val;
                    break;
                }
                case 1: {
                    this.devCount = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int select = 0;
        int obc = 0;
        if (onlyIndex == 0) {
            select = ((Number)parms[0].getValue()).intValue();
            Rc5Translator.insert(hexData, 6, 2, select);
        } else if (onlyIndex == 1) {
            int flag;
            obc = ((Number)parms[1].getValue()).intValue();
            select = hexData.getData()[0] & 3;
            if (select >= this.devCount) {
                select = 0;
            }
            if ((flag = ((Number)devParms[2 * select + this.devOffset + 1].getValue()).intValue()) == 0 && obc > 63 || flag == 1 && obc < 64) {
                int device = ((Number)devParms[2 * select + this.devOffset].getValue()).intValue();
                for (int i = 0; i < this.devCount; ++i) {
                    int index;
                    if (i == select || devParms[index = 2 * i + this.devOffset] == null || devParms[index].getValue() == null) continue;
                    int tempDevice = ((Number)devParms[index].getValue()).intValue();
                    int tempFlag = ((Number)devParms[index + 1].getValue()).intValue();
                    if (tempDevice != device || tempFlag == flag) continue;
                    Rc5Translator.insert(hexData, 6, 2, i);
                }
            }
            Rc5Translator.insert(hexData, 0, 6, Rc5Translator.complement(obc & 0x3F, 6));
        } else {
            if (parms[0] == null || parms[0].getValue() == null) {
                return;
            }
            select = ((Number)parms[0].getValue()).intValue();
            Rc5Translator.insert(hexData, 6, 2, select);
            if (parms[1] == null || parms[1].getValue() == null) {
                return;
            }
            obc = ((Number)parms[1].getValue()).intValue();
            Rc5Translator.insert(hexData, 0, 6, Rc5Translator.complement(obc, 6));
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        int select = hex.getData()[0] & 3;
        if (select >= this.devCount) {
            select = 0;
        }
        parms[0] = new Value(new Integer(select));
        int obc = Rc5Translator.complement(Rc5Translator.extract(hex, 0, 6), 6);
        while (select >= 0) {
            int index = 2 * select + this.devOffset;
            if (devParms[index] != null && devParms[index].getValue() != null) {
                int flag = ((Number)devParms[index + 1].getValue()).intValue();
                if (flag == 0) break;
                obc |= 0x40;
                break;
            }
            --select;
        }
        parms[1] = new Value(new Integer(obc));
    }
}

