/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class Sony1220Translator
extends Translate {
    private int deviceIndex = 1;

    public Sony1220Translator(String[] textParms) {
        super(textParms);
        if (textParms == null || textParms.length == 0) {
            return;
        }
        this.deviceIndex = Integer.parseInt(textParms[0]);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int device = 0;
        int flag = 1;
        Value val = parms[this.deviceIndex];
        if (val.hasUserValue()) {
            flag = 0;
            device = ((Number)val.getUserValue()).intValue();
        }
        Sony1220Translator.insert(hexData, 7, 1, flag);
        Sony1220Translator.insert(hexData, 8, 8, Sony1220Translator.reverse(device));
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        int flag = Sony1220Translator.extract(hexData, 7, 1);
        Integer device = null;
        if (flag == 0) {
            device = new Integer(Sony1220Translator.reverse(Sony1220Translator.extract(hexData, 8, 8)));
        }
        parms[this.deviceIndex] = new Value(device, null);
    }
}

