/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class SonyComboImporter
extends Translate {
    private static int Sony12 = 0;
    private static int Sony15 = 1;
    private static int Sony20 = 2;

    public SonyComboImporter(String[] textParms) {
        super(textParms);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int parmToSet) {
        if (parmToSet < 0) {
            return;
        }
        int device = 0;
        int protocol = 0;
        int subDevice = 0;
        if (parms.length == 1) {
            device = ((Number)parms[0].getValue()).intValue();
            protocol = device > 31 ? Sony15 : Sony12;
        } else {
            device = (Integer)parms[1].getValue();
            int temp = (Integer)parms[0].getValue();
            if (temp > 0 && temp < 5) {
                protocol = Sony20;
                subDevice = temp - 1;
            } else {
                protocol = temp == 5 ? Sony12 : Sony15;
            }
        }
        if (protocol == Sony12) {
            SonyComboImporter.insert(hexData, 7, 1, 0);
            SonyComboImporter.insert(hexData, 13, 3, 0);
            SonyComboImporter.insert(hexData, 8, 5, SonyComboImporter.reverse(device, 5));
        } else if (protocol == Sony15) {
            SonyComboImporter.insert(hexData, 7, 1, 1);
            SonyComboImporter.insert(hexData, 8, 8, SonyComboImporter.reverse(device, 8));
        } else {
            SonyComboImporter.insert(hexData, 7, 1, 0);
            SonyComboImporter.insert(hexData, 15, 1, 1);
            SonyComboImporter.insert(hexData, 8, 5, SonyComboImporter.reverse(device, 5));
            SonyComboImporter.insert(hexData, 13, 2, subDevice);
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
    }
}

