/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class SonyComboTranslator
extends Translate {
    public SonyComboTranslator(String[] textParms) {
        super(textParms);
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int parmToSet) {
        if (parmToSet < 0 || parmToSet == 3) {
            return;
        }
        int parm = ((Number)parms[parmToSet].getValue()).intValue();
        switch (parmToSet) {
            case 0: {
                int protocol = parm;
                if (protocol == 0) {
                    SonyComboTranslator.insert(hexData, 7, 1, 0);
                    SonyComboTranslator.insert(hexData, 13, 3, 0);
                    break;
                }
                if (protocol == 1) {
                    SonyComboTranslator.insert(hexData, 7, 1, 1);
                    break;
                }
                SonyComboTranslator.insert(hexData, 7, 1, 0);
                SonyComboTranslator.insert(hexData, 15, 1, 1);
                SonyComboTranslator.insert(hexData, 13, 2, 0);
                break;
            }
            case 1: {
                boolean isSony15;
                int device = parm;
                if (parm > 31) {
                    SonyComboTranslator.insert(hexData, 7, 1, 1);
                }
                boolean bl = isSony15 = SonyComboTranslator.extract(hexData, 7, 1) == 1;
                if (isSony15) {
                    SonyComboTranslator.insert(hexData, 8, 8, SonyComboTranslator.reverse(device, 8));
                    break;
                }
                SonyComboTranslator.insert(hexData, 8, 5, SonyComboTranslator.reverse(device, 5));
                break;
            }
            case 2: {
                boolean isSony15;
                int subDevice = parm;
                boolean bl = isSony15 = SonyComboTranslator.extract(hexData, 7, 1) == 1;
                if (subDevice == 0) {
                    if (isSony15) break;
                    SonyComboTranslator.insert(hexData, 13, 3, 0);
                    break;
                }
                SonyComboTranslator.insert(hexData, 7, 1, 0);
                SonyComboTranslator.insert(hexData, 13, 2, subDevice - 1);
                SonyComboTranslator.insert(hexData, 15, 1, 1);
            }
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        boolean isSony15;
        boolean bl = isSony15 = SonyComboTranslator.extract(hex, 7, 1) == 1;
        if (isSony15) {
            int device = SonyComboTranslator.reverse(SonyComboTranslator.extract(hex, 8, 8), 8);
            parms[0] = new Value(new Integer(1), null);
            parms[1] = new Value(new Integer(device), null);
            parms[2] = new Value(new Integer(0), null);
        } else {
            boolean isSony20;
            boolean bl2 = isSony20 = SonyComboTranslator.extract(hex, 15, 1) == 1;
            if (isSony20) {
                parms[0] = new Value(new Integer(2), null);
                int index = SonyComboTranslator.extract(hex, 13, 2) + 1;
                parms[2] = new Value(new Integer(index), null);
            } else {
                parms[0] = new Value(new Integer(0), null);
                parms[2] = parms[0];
            }
            int device = SonyComboTranslator.reverse(SonyComboTranslator.extract(hex, 8, 5), 5);
            parms[1] = new Value(new Integer(device), null);
        }
    }
}

