/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;

public abstract class Translate {
    public Translate(String[] textParms) {
    }

    public abstract void in(Value[] var1, Hex var2, DeviceParameter[] var3, int var4);

    public abstract void out(Hex var1, Value[] var2, DeviceParameter[] var3);

    public static int reverse(int b) {
        return Translate.reverse(b, 8);
    }

    public static int reverse(int v, int bits) {
        int rc = v >> 1 & 0x55555555 | (v & 0x55555555) << 1;
        rc = rc >> 2 & 0x33333333 | (rc & 0x33333333) << 2;
        rc = rc >> 4 & 0xF0F0F0F | (rc & 0xF0F0F0F) << 4;
        rc = rc >> 8 & 0xFF00FF | (rc & 0xFF00FF) << 8;
        rc = rc >>> 16 | rc << 16;
        return rc >>> 32 - bits;
    }

    public static int complement(int b) {
        return Translate.complement(b, 8);
    }

    public static int complement(int v, int bits) {
        return (2 << bits - 1) - 1 - v;
    }

    public static int byte2int(int b) {
        return b & 0xFF;
    }

    public static void insert(Hex hexData, int msbOffset, int bits, int v) {
        int lastOffset = msbOffset + bits - 1;
        int by = lastOffset / 8;
        short[] hex = hexData.getData();
        if (by >= hex.length) {
            System.err.println("insert(offset=" + msbOffset + ", bits=" + bits + ") exceeds " + hex.length + " byte buffer");
            return;
        }
        int bi = 7 - lastOffset % 8;
        int mask = (2 << bits - 1) - 1;
        while (mask != 0) {
            int mask2 = mask << bi;
            hex[by] = (short)((hex[by] & ~mask2 | v << bi & mask2) & 0xFF);
            mask >>>= 8 - bi;
            v >>= 8 - bi;
            bi = 0;
            --by;
        }
    }

    public static Value insert(Value data, int lsbOffset, int bits, int v) {
        int mask = (1 << bits) - 1 << lsbOffset;
        int old = 0;
        if (data != null) {
            old = (Integer)data.getValue() & -1 - mask;
        }
        return new Value(new Integer(old + (v << lsbOffset & mask)), null);
    }

    public static int extract(Hex hexData, int msbOffset, int bits) {
        short[] hex = hexData.getData();
        if (msbOffset + bits > 8 * hex.length) {
            System.err.println("extract(offset=" + msbOffset + ", bits=" + bits + ") exceeds " + hex.length + " int buffer");
            return 0;
        }
        int v = 0;
        int by = msbOffset / 8;
        int bi = msbOffset % 8;
        int mask = (256 >> bi) - 1;
        bits += bi;
        while (bits > 8) {
            v = (v << 8) + (hex[by] & mask);
            mask = 255;
            ++by;
            bits -= 8;
        }
        return (v << bits) + ((hex[by] & mask) >> 8 - bits);
    }
}

