/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DirectDefaultValue;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class Translator
extends Translate {
    protected boolean lsb = false;
    protected boolean comp = false;
    protected int styleIndex = -1;
    protected int index = 0;
    protected int bits = 8;
    protected int bitsIndex = -1;
    protected int bitOffset = 0;
    protected int lsbOffset = 0;
    protected int adjust = 0;
    protected static final int IndexIndex = 0;
    protected static final int BitsIndex = 1;
    protected static final int BitOffsetIndex = 2;
    protected static final int LsbOffsetIndex = 3;
    protected static final int AdjustOffset = 4;

    public Translator(String[] textParms) {
        super(textParms);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            if (text.equalsIgnoreCase("lsb")) {
                this.lsb = true;
                continue;
            }
            if (text.equalsIgnoreCase("comp")) {
                this.comp = true;
                continue;
            }
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.index = val;
                    break;
                }
                case 1: {
                    this.bits = val;
                    break;
                }
                case 2: {
                    this.bitOffset = val;
                    break;
                }
                case 3: {
                    this.lsbOffset = val;
                    break;
                }
                case 4: {
                    this.adjust = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    public Translator(boolean lsb, boolean comp, int index, int bits, int bitOffset) {
        super(null);
        this.lsb = lsb;
        this.comp = comp;
        this.index = index;
        this.bits = bits;
        this.bitOffset = bitOffset;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Translator)) {
            return false;
        }
        Translator t = (Translator)obj;
        return this.lsb == t.lsb && this.comp == t.comp && this.index == t.index && this.bits == t.bits && this.bitOffset == t.bitOffset;
    }

    private void adjustStyleAndBits(DeviceParameter[] devParms) {
        if (this.styleIndex != -1) {
            int style = ((Number)devParms[this.styleIndex].getValueOrDefault()).intValue();
            this.lsb = (style & 2) == 2;
            boolean bl = this.comp = (style & 1) == 1;
        }
        if (this.bitsIndex != -1) {
            this.bits = ((Number)devParms[this.bitsIndex].getValueOrDefault()).intValue();
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        this.adjustStyleAndBits(devParms);
        if (onlyIndex >= 0 && onlyIndex != this.index) {
            return;
        }
        if (this.index >= parms.length) {
            System.err.println("Translator.in() index=" + this.index + " exceeds " + parms.length + " item buffer");
            return;
        }
        int w = 0;
        Value v = parms[this.index];
        if (v == null) {
            System.err.println("Translator.in() index=" + this.index + " missing parameter");
        } else {
            Object o = v.getValue();
            Number i = null;
            if (o == null) {
                System.err.println("Translator.in() index=" + this.index + " missing parameter value");
                return;
            }
            if (o.getClass() == Integer.class || o.getClass() == Short.class) {
                i = (Number)v.getValue();
            } else if (o.getClass() == String.class) {
                i = new Integer((String)o);
            } else if (o instanceof DirectDefaultValue) {
                i = (Number)((DefaultValue)o).value();
            }
            w = i.intValue() + this.adjust >> this.lsbOffset;
        }
        if (this.getComp()) {
            w = -1 - w;
        }
        if (this.getLSB()) {
            w = Translator.reverse(w, this.bits);
        }
        Translator.insert(hexData, this.bitOffset, this.bits, w);
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        this.adjustStyleAndBits(devParms);
        if (this.index >= parms.length) {
            System.err.println("Translator.out() index=" + this.index + " exceeds " + parms.length + " item buffer");
            return;
        }
        int w = Translator.extract(hexData, this.bitOffset, this.bits);
        if (this.getComp()) {
            w = (2 << this.bits - 1) - 1 - w;
        }
        if (this.getLSB()) {
            w = Translator.reverse(w, this.bits);
        }
        parms[this.index] = Translator.insert(parms[this.index], this.lsbOffset, this.bits, w);
        if (this.adjust != 0) {
            parms[this.index] = new Value(new Integer((Integer)parms[this.index].getValue() - this.adjust), null);
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Translator(");
        if (this.getLSB()) {
            buff.append("lsb,");
        }
        if (this.getComp()) {
            buff.append("comp,");
        }
        buff.append(this.index);
        if (this.bits != 8 || this.bitOffset != 0 || this.lsbOffset != 0) {
            buff.append(',');
            buff.append(this.bits);
        }
        if (this.bitOffset != 0 || this.lsbOffset != 0) {
            buff.append(',');
            buff.append(this.bitOffset);
        }
        if (this.lsbOffset != 0) {
            buff.append(',');
            buff.append(this.lsbOffset);
        }
        buff.append(')');
        return buff.toString();
    }

    public boolean getLSB() {
        return this.lsb;
    }

    public void setLSB(boolean lsb) {
        this.lsb = lsb;
    }

    public boolean getComp() {
        return this.comp;
    }

    public void setComp(boolean comp) {
        this.comp = comp;
    }

    public void setStyleIndex(int index) {
        this.styleIndex = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getBitsIndex() {
        return this.bitsIndex;
    }

    public void setBitsIndex(int index) {
        this.bitsIndex = index;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public void setBitOffset(int newOffset) {
        this.bitOffset = newOffset;
    }
}

