/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translator;

public class TranslatorWithDevBool
extends Translator {
    private int devIndex = 0;

    public TranslatorWithDevBool(String[] textParms) {
        super(new String[0]);
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i];
            if (text.equalsIgnoreCase("lsb")) {
                this.lsb = true;
                continue;
            }
            if (text.equalsIgnoreCase("comp")) {
                this.comp = true;
                continue;
            }
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.devIndex = val;
                    break;
                }
                case 1: {
                    this.index = val;
                    break;
                }
                case 2: {
                    this.bits = val;
                    break;
                }
                case 3: {
                    this.bitOffset = val;
                    break;
                }
                case 4: {
                    this.lsbOffset = val;
                    break;
                }
                case 5: {
                    this.adjust = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void out(Hex hexData, Value[] parms, DeviceParameter[] devParms) {
        super.out(hexData, parms, devParms);
        Number v = (Number)parms[this.index].getValue();
        Number i = (Number)devParms[this.devIndex].getValueOrDefault();
        int val = (i.intValue() << this.bits) + v.intValue();
        parms[this.index] = new Value(new Integer(val));
    }
}

