/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;

public class X10Translator
extends Translate {
    public X10Translator(String[] textParms) {
        super(textParms);
    }

    @Override
    public void in(Value[] parms, Hex hex, DeviceParameter[] devParms, int onlyIndex) {
        int code = ((Number)parms[0].getValue()).intValue();
        if (code < 16) {
            code ^= 0xC;
            code ^= 10 * (code >> 2 & 1);
            code = X10Translator.reverse(code, 4);
            X10Translator.insert(hex, 1, 4, code);
        } else {
            X10Translator.insert(hex, 1, 4, code &= 0xF);
            X10Translator.insert(hex, 5, 1, 1);
        }
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
        int code = X10Translator.extract(hex, 1, 5);
        if ((code & 1) == 0) {
            code >>= 1;
            code = X10Translator.reverse(code, 4);
            code ^= 10 * (code >> 2 & 1);
            parms[0] = X10Translator.insert(parms[0], 0, 4, code ^= 0xC);
        } else {
            parms[0] = X10Translator.insert(parms[0], 0, 5, (code >>= 1) + 16);
        }
    }
}

