/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.translate;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;
import java.util.ArrayList;

public class XorCheck
extends Translate {
    private int bits = 8;
    private int destOffset = 8;
    private int seed = 0;
    private int count = 1;
    private int sourceOffset = 0;
    private int step = 8;
    private int devCount = 0;
    private int devSourceOffset = 0;
    private int devStep = 8;
    private boolean lsb = false;
    private boolean comp = false;
    private static final int bitsIndex = 0;
    private static final int destOffsetIndex = 1;
    private static final int seedIndex = 2;
    private static final int countIndex = 3;
    private static final int sourceOffsetIndex = 4;
    private static final int stepIndex = 5;
    private static final int devCountIndex = 6;
    private static final int devSourceOffsetIndex = 7;
    private static final int devStepIndex = 8;

    public XorCheck(String[] textParms) {
        super(textParms);
        ArrayList<String> parms = new ArrayList<String>();
        for (String str : textParms) {
            int ndx = str.indexOf(59);
            if (ndx >= 0) {
                this.count = 0;
                String part = str.substring(0, ndx).trim();
                if (!part.isEmpty()) {
                    parms.add(part);
                }
                parms.add(";");
                part = str.substring(ndx + 1).trim();
                if (part.isEmpty()) continue;
                parms.add(part);
                continue;
            }
            parms.add(str.trim());
        }
        int parmIndex = 0;
        boolean semicolon = false;
        for (String text : parms) {
            if (text.equalsIgnoreCase("lsb")) {
                this.lsb = true;
                continue;
            }
            if (text.equalsIgnoreCase("comp")) {
                this.comp = true;
                continue;
            }
            if (text.equals(";")) {
                parmIndex = 6;
                semicolon = true;
                continue;
            }
            if (parmIndex >= 6 && !semicolon) break;
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.bits = val;
                    this.step = val;
                    this.sourceOffset = 8 - val;
                    this.devStep = val;
                    break;
                }
                case 1: {
                    this.destOffset = val;
                    this.sourceOffset = val - this.bits;
                    break;
                }
                case 2: {
                    this.seed = val;
                    break;
                }
                case 3: {
                    this.count = val;
                    this.sourceOffset = this.destOffset - val * this.bits;
                    break;
                }
                case 4: {
                    this.sourceOffset = val;
                    break;
                }
                case 5: {
                    this.step = val;
                    this.devStep = val;
                    break;
                }
                case 6: {
                    this.devCount = val;
                    break;
                }
                case 7: {
                    this.devSourceOffset = val;
                    break;
                }
                case 8: {
                    this.devStep = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void in(Value[] parms, Hex hexData, DeviceParameter[] devParms, int onlyIndex) {
        int i;
        Hex devHex = null;
        if (this.devCount > 0) {
            devHex = new Hex(devParms.length);
            for (int i2 = 0; i2 < devParms.length; ++i2) {
                Object parmValue = devParms[i2].getValueOrDefault();
                if (parmValue == null || !(parmValue instanceof Number)) {
                    System.err.println("XorCheck.in() device index=" + i2 + " missing parameter value");
                    continue;
                }
                Number n = (Number)parmValue;
                int w = n.intValue();
                if (this.comp) {
                    w = 255 - w;
                }
                if (this.lsb) {
                    w = XorCheck.reverse(w, 8);
                }
                devHex.getData()[i2] = (short)w;
            }
        }
        int v = this.seed;
        int s = this.sourceOffset;
        for (i = 0; i < this.count; ++i) {
            v ^= XorCheck.extract(hexData, s, this.bits);
            s += this.step;
        }
        s = this.devSourceOffset;
        for (i = 0; i < this.devCount; ++i) {
            v ^= XorCheck.extract(devHex, s, this.bits);
            s += this.devStep;
        }
        XorCheck.insert(hexData, this.destOffset, this.bits, v);
    }

    @Override
    public void out(Hex hex, Value[] parms, DeviceParameter[] devParms) {
    }
}

