/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jni4net;

import java.io.File;
import java.io.IOException;
import net.sf.jni4net.BridgeSetup;
import net.sf.jni4net.CLRLoader;
import net.sf.jni4net.attributes.ClrMethod;
import net.sf.jni4net.attributes.ClrType;
import net.sf.jni4net.inj.IClrProxy;
import net.sf.jni4net.inj.IClrProxy_;
import net.sf.jni4net.inj.INJEnv;
import net.sf.jni4net.inj.INJException;
import net.sf.jni4net.jni.IJvmProxy;
import net.sf.jni4net.jni.IJvmProxy_;
import system.IObject;
import system.Object;
import system.String;
import system.Type;
import system.collections.IList;
import system.reflection.Assembly;

@ClrType
public class Bridge
extends Object {
    static boolean isRegistered;
    static boolean verbose;
    static boolean debug;
    static java.lang.String clrVersion;
    private static Type staticType;

    public static void init() throws IOException {
        Bridge.init(CLRLoader.findDefaultDll());
    }

    public static void init(File fileOrDirectory) throws IOException {
        CLRLoader.init(fileOrDirectory);
    }

    public static void setDebug(boolean value) {
        debug = value;
        if (isRegistered) {
            Bridge.getSetup().setDebug(value);
        }
    }

    public static void setVerbose(boolean value) {
        verbose = value;
        if (isRegistered) {
            Bridge.getSetup().setVerbose(value);
        }
    }

    public static void setClrVersion(java.lang.String value) {
        clrVersion = value;
    }

    public static synchronized java.lang.String getVersion() {
        return CLRLoader.getVersion();
    }

    public static synchronized boolean isRegistered() {
        return isRegistered;
    }

    public static boolean isCLRInstance(java.lang.Object obj) {
        return !Bridge.isJVMInstance(obj);
    }

    public static boolean isJVMInstance(java.lang.Object obj) {
        if (IObject.class.isAssignableFrom(obj.getClass())) {
            IObject o = (IObject)obj;
            return IClrProxy_.typeof().IsAssignableFrom(o.GetType());
        }
        return true;
    }

    public static Object wrapJVM(java.lang.Object obj) {
        if (IObject.class.isAssignableFrom(obj.getClass())) {
            if (IJvmProxy.class.isAssignableFrom(obj.getClass())) {
                return (Object)obj;
            }
            throw new INJException("Can't wrap CLR instance");
        }
        long clrHandle = Bridge.WrapJVM(obj);
        return IJvmProxy_.createProxy(clrHandle);
    }

    public static <TRes> TRes unwrapJVM(Object obj) {
        if (!IJvmProxy.class.isAssignableFrom(obj.getClass())) {
            throw new INJException("Can't unwrap JVM instance");
        }
        long clrHandle = obj.getClrHandle();
        return (TRes)Bridge.UnwrapJVM(clrHandle);
    }

    public static String convert(java.lang.String obj) {
        return new String(obj);
    }

    public static java.lang.String convert(String obj) {
        return obj.toString();
    }

    public static <TRes> TRes cast(java.lang.Object obj, Class<TRes> expectedInterface) {
        if (!IClrProxy.class.isAssignableFrom(obj.getClass())) {
            throw new INJException("Can't cast JVM instance");
        }
        if (IJvmProxy.class.isAssignableFrom(obj.getClass())) {
            throw new INJException("Can't cast JVM instance");
        }
        return (TRes)Bridge.Cast(obj, expectedInterface);
    }

    static native int initDotNet();

    static native long WrapJVM(java.lang.Object var0);

    static native java.lang.Object UnwrapJVM(long var0);

    public static native long Convert(java.lang.String var0);

    public static native void DisposeClrHandle(long var0);

    static native IClrProxy Cast(java.lang.Object var0, Class var1);

    protected Bridge(INJEnv __env, long __handle) {
        super(__env, __handle);
    }

    protected Bridge() {
        super(null, 0L);
    }

    @ClrMethod(value="()Lnet/sf/jni4net/BridgeSetup;")
    public static native BridgeSetup getSetup();

    @ClrMethod(value="()[[LSystem/Collections/Generic/IList`1;")
    public static native IList getKnownAssemblies();

    @ClrMethod(value="(Lnet/sf/jni4net/BridgeSetup;)Lnet/sf/jni4net/jni/JNIEnv;")
    public static native Object CreateJVM(BridgeSetup var0);

    @ClrMethod(value="(Ljava/io/File;)V")
    public static native void LoadAndRegisterAssemblyFrom(File var0);

    @ClrMethod(value="(Ljava/io/File;Ljava/lang/ClassLoader;)V")
    public static native void LoadAndRegisterAssemblyFrom(File var0, ClassLoader var1);

    @ClrMethod(value="(LSystem/String;)V")
    public static native void LoadAndRegisterAssemblyByName(java.lang.String var0);

    @ClrMethod(value="(LSystem/Reflection/Assembly;)V")
    public static native void RegisterAssembly(Assembly var0);

    @ClrMethod(value="(Ljava/lang/ClassLoader;)V")
    public static native void SetSystemClassLoader(ClassLoader var0);

    public static Type typeof() {
        return staticType;
    }

    private static void InitJNI(INJEnv env, Type staticType) {
        Bridge.staticType = staticType;
    }
}

