/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jni4net;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Properties;
import net.sf.jni4net.Bridge;
import net.sf.jni4net.inj.INJException;

class CLRLoader {
    private static String version;
    private static String platform;

    CLRLoader() {
    }

    public static void init(File fileOrDirectory) throws IOException {
        if (!Bridge.isRegistered) {
            if (fileOrDirectory.isDirectory()) {
                String myDllName = "jni4net.n." + CLRLoader.getPlatform() + "." + CLRLoader.getClr() + "-" + CLRLoader.getVersion() + ".dll";
                CLRLoader.init(new File(fileOrDirectory, myDllName).getAbsoluteFile());
                return;
            }
            try {
                String file = fileOrDirectory.getPath();
                System.load(file);
                int res = Bridge.initDotNet();
                if (res != 0) {
                    System.err.println("Can't initialize jni4net Bridge from " + file);
                    throw new INJException("Can't initialize jni4net Bridge. Code:" + res);
                }
                Bridge.isRegistered = true;
            }
            catch (Throwable th) {
                System.err.println("Can't initialize jni4net Bridge" + th.getMessage());
                throw new INJException("Can't initialize jni4net Bridge", th);
            }
        }
    }

    static File findDefaultDll() throws IOException {
        File path;
        String file;
        CodeSource source = Bridge.class.getProtectionDomain().getCodeSource();
        try {
            file = new File(source.getLocation().toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        if (file.endsWith("classes")) {
            String base = file.substring(0, file.length() - 7).replaceAll("jni4net\\.j", "jni4net.n." + CLRLoader.getPlatform() + "." + CLRLoader.getClr()) + "/jni4net.n";
            path = new File(base + "." + CLRLoader.getPlatform() + "." + CLRLoader.getClr() + "-" + CLRLoader.getVersion() + ".dll");
            if (!path.exists()) {
                throw new Error("Can't find " + path);
            }
        } else if (file.endsWith(".jar")) {
            String base = file.substring(0, file.length() - 4).replaceAll("jni4net\\.j", "jni4net.n." + CLRLoader.getPlatform() + "." + CLRLoader.getClr());
            path = new File(base + ".dll");
        } else {
            throw new Error("Can't find " + file);
        }
        return path;
    }

    public static String getProperty(String property) {
        URL resource = CLRLoader.class.getClassLoader().getResource("META-INF/jni4net.properties");
        if (resource != null) {
            try {
                Properties p = new Properties();
                InputStream ins = resource.openStream();
                p.load(ins);
                ins.close();
                return p.getProperty(property, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized String getClr() {
        if (Bridge.clrVersion == null) {
            Bridge.clrVersion = "v20";
            if (CLRLoader.getPlatform().startsWith("w")) {
                File d;
                String[] vers;
                String sysRoot = System.getenv("SystemRoot");
                if (sysRoot == null || sysRoot.equals("")) {
                    sysRoot = "c:/Windows";
                }
                if ((vers = (d = new File(sysRoot, "Microsoft.NET/Framework/")).list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("v4.0.");
                    }
                })) != null && vers.length > 0) {
                    Bridge.clrVersion = "v40";
                }
            } else if (CLRLoader.getPlatform().startsWith("l")) {
                Bridge.clrVersion = "m26";
            }
        }
        return Bridge.clrVersion;
    }

    public static synchronized String getPlatform() {
        if (platform == null) {
            String model = System.getProperty("sun.arch.data.model");
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("windows")) {
                platform = "w";
            } else if (os.equals("linux")) {
                platform = "l";
            } else {
                System.out.println(os);
                throw new UnsupportedOperationException("Platform not supported " + os);
            }
            platform = platform + model;
        }
        return platform;
    }

    public static synchronized String getVersion() {
        if (version == null) {
            version = CLRLoader.getProperty("jni4net.version");
        }
        return version;
    }
}

