/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.DecodeException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.NonUniqueBitCodeException;

public abstract class AbstractBiphaseDecoder
extends AbstractDecoder {
    protected final int half;
    protected final int full;
    private final boolean invert;

    protected static BitSpec mkBitSpec(double duration, double timebase, boolean invert, Burst.Preferences burstPrefs) {
        Flash on = Burst.newFlash(duration, timebase, burstPrefs);
        Gap off = Burst.newGap(duration, timebase, burstPrefs);
        ArrayList<IrStreamItem> listOffOn = new ArrayList<IrStreamItem>(2);
        listOffOn.add(off);
        listOffOn.add(on);
        ArrayList<IrStreamItem> listOnOff = new ArrayList<IrStreamItem>(2);
        listOnOff.add(on);
        listOnOff.add(off);
        ArrayList<BareIrStream> list = new ArrayList<BareIrStream>(2);
        if (invert) {
            list.add(new BareIrStream(listOnOff));
            list.add(new BareIrStream(listOffOn));
        } else {
            list.add(new BareIrStream(listOffOn));
            list.add(new BareIrStream(listOnOff));
        }
        try {
            return new BitSpec(list);
        }
        catch (NonUniqueBitCodeException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public AbstractBiphaseDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params, int half, int full, boolean invert) {
        super(analyzer, params);
        this.invert = invert != params.isInvert();
        this.bitSpec = AbstractBiphaseDecoder.mkBitSpec(this.timebase, this.timebase, this.invert, params.getBurstPrefs());
        this.half = half;
        this.full = full;
    }

    public AbstractBiphaseDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params, boolean invert) {
        this(analyzer, params, analyzer.getTiming(0), analyzer.getTiming(1), invert);
    }

    @Override
    protected List<IrStreamItem> parse(int beg, int length) throws DecodeException {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(2 * length);
        AbstractDecoder.ParameterData data = new AbstractDecoder.ParameterData();
        int foundStartBits = 0;
        BiphaseState state = BiphaseState.start;
        for (int index = beg; index < beg + length; ++index) {
            int noBitsLimit = this.params.getNoBitsLimit(this.noPayload);
            boolean isFlash = index % 2 == 0;
            boolean useExtent = this.params.isUseExtents() && index == beg + length - 1;
            int time = this.analyzer.getCleanedTime(index);
            boolean isShort = time == this.half;
            boolean isLong = time == this.full;
            switch (state.ordinal()) {
                case 0: {
                    if (this.startDurations() == 0) {
                        if (!isFlash) {
                            throw new ThisCannotHappenException();
                        }
                        if (isShort) {
                            if (this.invert) {
                                data.update(1);
                                state = BiphaseState.zero;
                                break;
                            }
                            state = BiphaseState.pendingFlash;
                            break;
                        }
                        this.saveParameter(data, items, this.params.getBitDirection());
                        data = new AbstractDecoder.ParameterData();
                        items.add(this.newFlash(time));
                        state = BiphaseState.zero;
                        break;
                    }
                    items.add(this.newFlashOrGap(isFlash, time));
                    if (++foundStartBits != this.startDurations()) break;
                    state = BiphaseState.zero;
                    break;
                }
                case 1: {
                    if (!isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(this.invert);
                    if (isShort) {
                        state = BiphaseState.zero;
                        break;
                    }
                    if (isLong) {
                        state = BiphaseState.pendingFlash;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(this.newFlash(time - this.half));
                    state = BiphaseState.zero;
                    break;
                }
                case 2: {
                    if (isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(!this.invert);
                    if (isShort) {
                        state = BiphaseState.zero;
                        break;
                    }
                    if (isLong) {
                        state = BiphaseState.pendingGap;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(useExtent ? this.newExtent(this.analyzer.getTotalDuration(beg, length - 1) + time - this.half) : this.newGap(time - this.half));
                    state = BiphaseState.zero;
                    break;
                }
                case 3: {
                    if (isShort) {
                        state = isFlash ? BiphaseState.pendingFlash : BiphaseState.pendingGap;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(isFlash ? this.newFlash(time) : (useExtent ? this.newExtent(this.analyzer.getTotalDuration(beg, length - 1) + time) : this.newGap(time)));
                    break;
                }
                default: {
                    throw new ThisCannotHappenException();
                }
            }
            if (data.getNoBits() < noBitsLimit) continue;
            this.saveParameter(data, items, this.params.getBitDirection());
            data = new AbstractDecoder.ParameterData();
        }
        this.saveParameter(data, items, this.params.getBitDirection());
        return items;
    }

    protected abstract int startDurations();

    private static enum BiphaseState {
        start,
        pendingGap,
        pendingFlash,
        zero;

    }
}

