/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.BiphaseDecoder;
import org.harctoolbox.analyze.BiphaseInvertDecoder;
import org.harctoolbox.analyze.BiphaseWithDoubleToggleDecoder;
import org.harctoolbox.analyze.BiphaseWithDurationDecoder;
import org.harctoolbox.analyze.BiphaseWithDurationInvertDecoder;
import org.harctoolbox.analyze.BiphaseWithTwoDurationsDecoder;
import org.harctoolbox.analyze.BiphaseWithTwoDurationsInvertDecoder;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.DecodeException;
import org.harctoolbox.analyze.Pwm2Decoder;
import org.harctoolbox.analyze.Pwm4AltDecoder;
import org.harctoolbox.analyze.Pwm4Decoder;
import org.harctoolbox.analyze.RepeatFinder;
import org.harctoolbox.analyze.SerialDecoder;
import org.harctoolbox.analyze.TrivialDecoder;
import org.harctoolbox.analyze.XmpDecoder;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitspecIrstream;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Extent;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.RepeatMarker;

public abstract class AbstractDecoder {
    static final Class<?>[] decoders = new Class[]{TrivialDecoder.class, Pwm2Decoder.class, Pwm4Decoder.class, Pwm4AltDecoder.class, XmpDecoder.class, BiphaseDecoder.class, BiphaseInvertDecoder.class, BiphaseWithDurationDecoder.class, BiphaseWithDurationInvertDecoder.class, BiphaseWithTwoDurationsDecoder.class, BiphaseWithTwoDurationsInvertDecoder.class, BiphaseWithDoubleToggleDecoder.class, SerialDecoder.class};
    protected static final int NUMBERDECODERS = decoders.length;
    protected static final int CANNOT_MATCH = Integer.MIN_VALUE;
    protected NameEngine nameEngine = null;
    protected int noPayload;
    protected final double timebase;
    protected final Analyzer analyzer;
    protected BitSpec bitSpec;
    protected final Analyzer.AnalyzerParams params;

    public static List<String> decoderNames() {
        ArrayList<String> result = new ArrayList<String>(NUMBERDECODERS);
        for (Class<?> decoder : decoders) {
            result.add(decoder.getSimpleName());
        }
        return result;
    }

    public AbstractDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params) {
        this.analyzer = analyzer;
        this.params = params;
        this.timebase = analyzer.getTimeBaseFromData(params);
        this.bitSpec = new BitSpec();
    }

    public Protocol[] parse() throws DecodeException {
        return this.parse(false);
    }

    public Protocol[] parse(boolean signalMode) throws DecodeException {
        Protocol[] result = new Protocol[this.analyzer.getNoSequences()];
        for (int i = 0; i < this.analyzer.getNoSequences(); ++i) {
            result[i] = this.parse(i, signalMode);
        }
        return result;
    }

    Protocol parse(int number, boolean signalMode) throws DecodeException {
        IrStream irStream;
        assert (!signalMode || number <= 0);
        this.noPayload = 0;
        this.nameEngine = new NameEngine();
        if (signalMode) {
            List<IrStreamItem> items = this.parse(this.analyzer.getSequenceBegin(0), this.analyzer.getSequenceLength(0));
            List<IrStreamItem> repeatItems = this.parse(this.analyzer.getSequenceBegin(1), this.analyzer.getSequenceLength(1));
            List<IrStreamItem> endingItems = this.parse(this.analyzer.getSequenceBegin(2), this.analyzer.getSequenceLength(2));
            RepeatMarker repeatMarker = new RepeatMarker("*");
            if (this.analyzer.getSequenceLength(0) == 0 && this.analyzer.getSequenceLength(2) == 0) {
                irStream = new IrStream(repeatItems, repeatMarker);
            } else {
                if (!repeatItems.isEmpty()) {
                    items.add(new IrStream(repeatItems, repeatMarker));
                }
                if (!endingItems.isEmpty()) {
                    items.add(new IrStream(endingItems));
                }
                irStream = new IrStream(items);
            }
        } else {
            int begin = this.analyzer.getSequenceBegin(number);
            RepeatFinder.RepeatFinderData repeatfinderData = this.analyzer.getRepeatFinderData(number);
            List<IrStreamItem> items = this.parse(begin, repeatfinderData.getBeginLength());
            List<IrStreamItem> repeatItems = this.parse(begin + repeatfinderData.getBeginLength(), repeatfinderData.getRepeatLength());
            List<IrStreamItem> endingItems = this.parse(begin + repeatfinderData.getEndingStart(), repeatfinderData.getEndingLength());
            RepeatMarker repeatMarker = new RepeatMarker(repeatfinderData.getNumberRepeats());
            if (repeatfinderData.getBeginLength() == 0 && repeatfinderData.getEndingLength() == 0) {
                irStream = new IrStream(repeatItems, repeatMarker);
            } else {
                if (!repeatItems.isEmpty()) {
                    items.add(new IrStream(repeatItems, repeatMarker));
                }
                if (!endingItems.isEmpty()) {
                    items.add(new IrStream(endingItems));
                }
                irStream = new IrStream(items);
            }
        }
        BitspecIrstream bitspecIrstream = new BitspecIrstream(this.bitSpec, irStream);
        return new Protocol(this.params.getGeneralSpec(this.timebase), bitspecIrstream, this.nameEngine, null, null, this.getClass());
    }

    protected Flash newFlash(int flash) {
        return Burst.newFlash(flash, this.timebase, this.params.getBurstPrefs());
    }

    protected Extent newExtent(int total) {
        return Burst.newExtent(total, this.timebase, this.params.getBurstPrefs());
    }

    protected Gap newGap(int gap) {
        return Burst.newGap(gap, this.timebase, this.params.getBurstPrefs());
    }

    protected Duration newFlashOrGap(boolean isFlash, int time) {
        return isFlash ? this.newFlash(time) : this.newGap(time);
    }

    protected void saveParameter(ParameterData parameterData, List<IrStreamItem> items, BitDirection bitDirection) {
        this.saveParameter(parameterData, items, bitDirection, false);
    }

    protected void saveParameter(ParameterData parameterData, List<IrStreamItem> items, BitDirection bitDirection, boolean complement) {
        this.saveParameter(null, parameterData, items, bitDirection, complement);
    }

    protected void saveParameter(BitSpec bitSpec, ParameterData parameterData, List<IrStreamItem> items, BitDirection bitDirection, boolean complement) {
        if (parameterData.isEmpty()) {
            return;
        }
        parameterData.fixBitDirection(bitDirection);
        if (complement) {
            parameterData.invertData();
        }
        String name = this.params.mkName(this.noPayload);
        ++this.noPayload;
        try {
            this.nameEngine.define(name, parameterData.getData());
            FiniteBitField bitField = new FiniteBitField(name, parameterData.getNoBits());
            if (bitSpec == null) {
                items.add(bitField);
            } else {
                ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(1);
                list.add(bitField);
                IrStream irStream = new IrStream(list);
                BitspecIrstream bitspecIrstream = new BitspecIrstream(bitSpec, irStream);
                items.add(bitspecIrstream);
            }
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException();
        }
    }

    protected abstract List<IrStreamItem> parse(int var1, int var2) throws DecodeException;

    protected int getNoBitsLimit(List<Integer> parameterWidths) {
        return parameterWidths == null || this.noPayload >= parameterWidths.size() ? Integer.MAX_VALUE : parameterWidths.get(this.noPayload);
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    protected void dumpParameters(ParameterData data, List<IrStreamItem> items, int noBitsLimit, boolean invert) {
        ParameterData lowerParam = data.reduce(noBitsLimit);
        this.saveParameter(lowerParam, items, this.params.getBitDirection(), invert);
    }

    protected void dumpParameters(ParameterData data, List<IrStreamItem> items, int noBitsLimit) {
        this.dumpParameters(data, items, noBitsLimit, false);
    }

    protected static class ParameterData {
        private BigInteger data;
        private int noBits;
        private final int chunkSize;

        private ParameterData(long data, int noBits, int chunkSize) {
            this(BigInteger.valueOf(data), noBits, chunkSize);
        }

        private ParameterData(BigInteger data, int noBits, int chunkSize) {
            this.data = data;
            this.noBits = noBits;
            this.chunkSize = chunkSize;
        }

        ParameterData(int chunkSize) {
            this(0L, 0, chunkSize);
        }

        ParameterData() {
            this(1);
        }

        public String toString(int radix) {
            return IrCoreUtils.radixPrefix(radix) + this.getData().toString(radix) + ":" + Integer.toString(this.getNoBits());
        }

        public String toString() {
            return this.toString(10);
        }

        public void update(int amount) {
            this.update(amount, this.chunkSize);
        }

        public void update(int amount, int bits) {
            this.update(BigInteger.valueOf(amount), bits);
        }

        public void update(BigInteger amount, int bits) {
            this.data = this.data.shiftLeft(bits);
            this.data = this.data.or(amount);
            this.noBits += bits;
        }

        public void update(boolean invert) {
            this.update(invert ? 1 : 0);
        }

        public ParameterData reduce(int maxBits) {
            ParameterData pd;
            if (this.noBits <= maxBits) {
                pd = new ParameterData(this.data, this.noBits, this.chunkSize);
                this.data = BigInteger.ZERO;
                this.noBits = 0;
            } else {
                pd = new ParameterData(this.data.shiftRight(this.noBits - maxBits), maxBits, this.chunkSize);
                this.noBits -= maxBits;
                this.data = this.data.and(BigInteger.valueOf(IrCoreUtils.ones(this.noBits)));
            }
            return pd;
        }

        private void invertData() {
            BigInteger mask = BigInteger.valueOf(IrCoreUtils.ones(this.noBits));
            this.data = this.data.xor(mask);
        }

        private void fixBitDirection(BitDirection bitDirection) {
            if (bitDirection == BitDirection.lsb) {
                this.data = IrCoreUtils.reverse(this.getData(), this.getNoBits());
            }
        }

        public BigInteger getData() {
            return this.data;
        }

        public int getNoBits() {
            return this.noBits;
        }

        public boolean isEmpty() {
            return this.noBits == 0;
        }
    }
}

