/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.Cleaner;
import org.harctoolbox.analyze.DecodeException;
import org.harctoolbox.analyze.NoDecoderMatchException;
import org.harctoolbox.analyze.RepeatFinder;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.Protocol;

public final class Analyzer
extends Cleaner {
    private static final Logger logger = Logger.getLogger(Analyzer.class.getName());
    private List<Burst> pairs;
    private final RepeatFinder.RepeatFinderData[] repeatFinderData;
    private Double frequency;
    private List<Burst> sortedBursts;

    public static int[] mkIndices(Collection<? extends IrSequence> irSequenceList) {
        int[] indices = new int[irSequenceList.size()];
        int i = 0;
        for (IrSequence irSequence : irSequenceList) {
            indices[i] = irSequence.getLength() + (i > 0 ? indices[i - 1] : 0);
            ++i;
        }
        return indices;
    }

    public static Protocol selectBestProtocol(List<Protocol> protocols) {
        Protocol bestSoFar = null;
        int weight = Integer.MAX_VALUE;
        for (Protocol protocol : protocols) {
            int protocolWeight = protocol.weight();
            if (protocolWeight >= weight) continue;
            bestSoFar = protocol;
            weight = protocolWeight;
        }
        return bestSoFar;
    }

    public Analyzer(IrSignal irSignal, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(irSignal.toIrSequences(), Analyzer.mkIndices(irSignal.toIrSequences()), true, irSignal.getFrequency(), false, absoluteTolerance, relativeTolerance);
    }

    public Analyzer(IrSequence irSequence, Double frequency, boolean invokeRepeatFinder, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(Arrays.asList(irSequence), frequency, invokeRepeatFinder, absoluteTolerance, relativeTolerance);
    }

    public Analyzer(Collection<? extends IrSequence> irSequenceList, Double frequency, boolean invokeRepeatFinder, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(irSequenceList, Analyzer.mkIndices(irSequenceList), false, frequency, invokeRepeatFinder, absoluteTolerance, relativeTolerance);
    }

    private Analyzer(Collection<? extends IrSequence> irSequenceList, int[] indices, boolean signalMode, Double frequency, boolean invokeRepeatFinder, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        super(IrSequence.toInts(irSequenceList), indices, signalMode, absoluteTolerance, relativeTolerance);
        if (frequency == null) {
            logger.log(Level.FINE, String.format(Locale.US, "No frequency given, assuming default frequency = %d Hz", 38000));
        }
        this.frequency = frequency;
        this.repeatFinderData = new RepeatFinder.RepeatFinderData[irSequenceList.size()];
        for (int i = 0; i < irSequenceList.size(); ++i) {
            this.repeatFinderData[i] = this.getRepeatFinderData(invokeRepeatFinder, i);
        }
        this.createPairs();
    }

    public Analyzer(ModulatedIrSequence irSequence, boolean invokeRepeatFinder, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(irSequence, irSequence.getFrequency(), invokeRepeatFinder, absoluteTolerance, relativeTolerance);
    }

    public Analyzer(IrSequence irSequence, boolean invokeRepeatFinder) throws InvalidArgumentException {
        this(irSequence, null, invokeRepeatFinder, (Double)100.0, (Double)0.3);
    }

    public Analyzer(IrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(irSequence, null, false, absoluteTolerance, relativeTolerance);
    }

    public Analyzer(IrSequence irSequence) throws InvalidArgumentException {
        this(irSequence, null, false, null, null);
    }

    public Analyzer(int[] data) throws OddSequenceLengthException, InvalidArgumentException {
        this(new IrSequence(data), null, false, null, null);
    }

    public Analyzer(IrSequence irSequence, Double frequency, boolean invokeRepeatFinder) throws InvalidArgumentException {
        this(irSequence, frequency, invokeRepeatFinder, null, null);
    }

    public Analyzer(IrSignal irSignal) throws InvalidArgumentException {
        this(irSignal, null, null);
    }

    public Burst getBurst(int i) {
        return this.pairs.get(i);
    }

    public Burst getSortedBurst(int i) {
        return this.sortedBursts.get(i);
    }

    private RepeatFinder.RepeatFinderData getRepeatFinderData(boolean invokeRepeatFinder, int number) {
        int beg = this.getSequenceBegin(number);
        int length = this.getSequenceLength(number);
        try {
            return invokeRepeatFinder ? new RepeatFinder(this.toDurations(beg, length)).getRepeatFinderData() : new RepeatFinder.RepeatFinderData(length);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    RepeatFinder.RepeatFinderData getRepeatFinderData(int number) {
        return this.repeatFinderData[number];
    }

    public IrSignal repeatReducedIrSignal(int number) {
        try {
            IrSequence ending;
            IrSequence repeat;
            IrSequence intro;
            if (this.isSignalMode()) {
                intro = new IrSequence(this.toDurations(this.getSequenceBegin(0), this.getSequenceLength(0)));
                repeat = new IrSequence(this.toDurations(this.getSequenceBegin(1), this.getSequenceLength(1)));
                ending = new IrSequence(this.toDurations(this.getSequenceBegin(2), this.getSequenceLength(2)));
            } else {
                int begin = this.getSequenceBegin(number);
                RepeatFinder.RepeatFinderData repeatfinderData = this.getRepeatFinderData(number);
                intro = new IrSequence(this.toDurations(begin, repeatfinderData.getBeginLength()));
                repeat = new IrSequence(this.toDurations(begin + repeatfinderData.getBeginLength(), repeatfinderData.getRepeatLength()));
                ending = new IrSequence(this.toDurations(begin + repeatfinderData.getEndingStart(), repeatfinderData.getEndingLength()));
            }
            return new IrSignal(intro, repeat, ending, this.frequency);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    private void createPairs() {
        this.pairs = new ArrayList<Burst>(16);
        this.getFlashes().stream().forEach(flash -> this.getGaps().stream().filter(gap -> this.getNumberPairs((int)flash, (int)gap) > 0).forEach(gp -> this.pairs.add(new Burst((int)flash, (int)gp))));
        Collections.sort(this.pairs, (a, b) -> this.getNumberPairs((Burst)b) - this.getNumberPairs((Burst)a));
        this.sortedBursts = new ArrayList<Burst>(this.pairs);
        this.sortedBursts.sort((a, b) -> Burst.compare(a, b));
    }

    private List<Class<?>> selectDecoderClasses(String decoderPattern, boolean regexp) throws NoDecoderMatchException {
        List<Class<?>> decoders;
        List<Class<?>> list = decoders = regexp ? this.selectDecoderClassesRegexp(decoderPattern) : this.selectDecoderClassesSubstring(decoderPattern);
        if (decoders.isEmpty()) {
            throw new NoDecoderMatchException(decoderPattern, regexp);
        }
        return decoders;
    }

    private List<Class<?>> selectDecoderClassesRegexp(String decoderPattern) {
        Pattern pattern = decoderPattern != null ? Pattern.compile(decoderPattern, 2) : null;
        ArrayList decoders = new ArrayList(AbstractDecoder.NUMBERDECODERS);
        for (Class<?> decoderClass : AbstractDecoder.decoders) {
            if (pattern != null && !pattern.matcher(decoderClass.getSimpleName()).matches()) continue;
            decoders.add(decoderClass);
        }
        return decoders;
    }

    private List<Class<?>> selectDecoderClassesSubstring(String decoderPattern) {
        ArrayList decoders = new ArrayList(AbstractDecoder.NUMBERDECODERS);
        for (Class<?> decoderClass : AbstractDecoder.decoders) {
            if (decoderPattern != null && !decoderClass.getSimpleName().regionMatches(true, 0, decoderPattern, 0, decoderPattern.length())) continue;
            decoders.add(decoderClass);
        }
        return decoders;
    }

    private List<AbstractDecoder> setupDecoders(AnalyzerParams params, String decoderPattern, boolean regexp) throws NoDecoderMatchException {
        List<Class<?>> decoderClasses = this.selectDecoderClasses(decoderPattern, regexp);
        ArrayList<AbstractDecoder> decoders = new ArrayList<AbstractDecoder>(AbstractDecoder.NUMBERDECODERS);
        decoderClasses.forEach(decoderClass -> {
            try {
                Constructor constructor = decoderClass.getConstructor(Analyzer.class, AnalyzerParams.class);
                AbstractDecoder decoder = (AbstractDecoder)constructor.newInstance(this, params);
                decoders.add(decoder);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException ex) {
                throw new ThisCannotHappenException(ex);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.FINE, String.format("Decoder %1$s failed: %2$s(%3$s)", decoderClass.getSimpleName(), ex.getTargetException().getClass().getSimpleName(), ex.getTargetException().getMessage()));
            }
        });
        return decoders;
    }

    public List<Burst> getPairs() {
        return Collections.unmodifiableList(this.pairs);
    }

    public String getName(Burst pair) {
        return this.getName(pair.getFlashDuration()) + this.getName(pair.getGapDuration());
    }

    public int getNumberPairs(Burst pair) {
        return this.getNumberPairs(pair.getFlashDuration(), pair.getGapDuration());
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public List<List<Protocol>> searchAllProtocols(AnalyzerParams params, String decoderPattern, boolean regexp) throws NoDecoderMatchException {
        List<AbstractDecoder> decoders = this.setupDecoders(params, decoderPattern, regexp);
        ArrayList<List<Protocol>> result = new ArrayList<List<Protocol>>(this.getNoSequences());
        for (int i = 0; i < this.getNoSequences(); ++i) {
            result.add(this.searchProtocols(decoders, i));
        }
        return result;
    }

    public List<Protocol> searchBestProtocol(AnalyzerParams params, String decoderPattern, boolean regexp) throws NoDecoderMatchException {
        List<AbstractDecoder> decoders = this.setupDecoders(params, decoderPattern, regexp);
        ArrayList<Protocol> result = new ArrayList<Protocol>(this.getNoSequences());
        for (int i = 0; i < this.getNoSequences(); ++i) {
            Protocol best = this.searchBestProtocol(decoders, i);
            if (best == null) continue;
            result.add(best);
        }
        return result;
    }

    public List<Protocol> searchBestProtocol(AnalyzerParams analyzerParams) throws NoDecoderMatchException {
        return this.searchBestProtocol(analyzerParams, null, false);
    }

    public List<Protocol> searchProtocols(List<AbstractDecoder> decoders, int number) {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(decoders.size());
        decoders.forEach(decoder -> {
            try {
                Protocol protocol = decoder.parse(number, this.isSignalMode());
                protocols.add(protocol);
                logger.log(Level.FINE, "{0}: {1} w = {2}", new Object[]{decoder.name(), protocol.toIrpString(10), protocol.weight()});
            }
            catch (DecodeException ex) {
                logger.log(Level.FINE, "{0}: {1}", new Object[]{decoder.name(), ex.getMessage()});
            }
            catch (AnalyzerParams.TooFewParameterNamesException ex) {
                logger.log(Level.FINE, "{0}: Too few parameter names", new Object[]{decoder.name()});
            }
        });
        return protocols;
    }

    public Protocol searchBestProtocol(List<AbstractDecoder> decoders, int number) {
        List<Protocol> protocols = this.searchProtocols(decoders, number);
        return Analyzer.selectBestProtocol(protocols);
    }

    public void printStatistics(PrintStream out, AnalyzerParams params) {
        out.println("Timebase: " + this.getRealTimebase(params.getTimebase(), params.burstPrefs.getMaxRoundingError()));
        out.println();
        out.println("Gaps:");
        this.getGaps().stream().forEach(d -> out.println(this.getName((int)d) + ":\t" + d + "\t" + this.multiplierString((int)d, params.getTimebase(), params.burstPrefs) + "\t" + this.getNumberGaps((int)d)));
        out.println();
        out.println("Flashes:");
        this.getFlashes().stream().forEach(d -> out.println(this.getName((int)d) + ":\t" + d + "\t" + this.multiplierString((int)d, params.getTimebase(), params.burstPrefs) + "\t" + this.getNumberFlashes((int)d)));
        out.println();
        out.println("Pairs:");
        this.getPairs().stream().forEach(pair -> out.println(this.getName((Burst)pair) + ":\t" + this.getNumberPairs((Burst)pair)));
    }

    private double getRealTimebase(Double timebase, double relativeTolerance) {
        return timebase != null ? timebase : (double)this.getTimeBaseFromData(relativeTolerance);
    }

    private String multiplierString(int us, Double timebase, Burst.Preferences burstPrefs) {
        double tick = this.getRealTimebase(timebase, burstPrefs.getMaxRoundingError());
        Integer mult = Burst.multiplier(us, tick, burstPrefs);
        return mult != null ? "= " + mult.toString() + "*" + Long.toString(Math.round(tick)) + "  " : "\t";
    }

    public RepeatFinder.RepeatFinderData repeatFinderData(int i) {
        return this.repeatFinderData[i];
    }

    double getTimeBaseFromData(AnalyzerParams params) {
        Objects.requireNonNull(params);
        return params.getTimebase() != null ? params.getTimebase() : (double)this.getTimeBaseFromData(params.getBurstPrefs().getMaxRoundingError());
    }

    public static class AnalyzerParams {
        private final Double frequency;
        private final Double timebase;
        private final boolean preferPeriods;
        private final BitDirection bitDirection;
        private final boolean useExtents;
        private final boolean invert;
        private final List<Integer> parameterWidths;
        private final int maxParameterWidth;
        private final Burst.Preferences burstPrefs;
        private List<String> parameterNames;

        public AnalyzerParams(Double frequency, String timeBaseString, BitDirection bitDirection, boolean useExtents, List<Integer> parameterWidths, boolean invert) {
            this(frequency, timeBaseString, bitDirection, useExtents, parameterWidths, 32, invert, new Burst.Preferences(), new ArrayList<String>(0));
        }

        public AnalyzerParams() {
            this(null, null, BitDirection.lsb, false, null, 32, false, new Burst.Preferences(), new ArrayList<String>(0));
        }

        public AnalyzerParams(Double frequency, String timeBaseString, BitDirection bitDirection, boolean useExtents, List<Integer> parameterWidths, int maxParameterWidth, boolean invert, Burst.Preferences burstPrefs, List<String> parameterNames) {
            this.frequency = frequency;
            this.bitDirection = bitDirection;
            this.useExtents = useExtents;
            this.invert = invert;
            this.burstPrefs = burstPrefs;
            this.parameterWidths = parameterWidths == null ? new ArrayList(0) : parameterWidths;
            this.maxParameterWidth = maxParameterWidth;
            this.parameterNames = parameterNames;
            if (timeBaseString == null || timeBaseString.isEmpty()) {
                this.timebase = null;
                this.preferPeriods = false;
            } else {
                this.preferPeriods = timeBaseString.endsWith("p");
                if (this.preferPeriods && frequency == null) {
                    logger.warning("Period based timing selected, but no explicit frequency given.");
                }
                String str = timeBaseString.endsWith("p") || timeBaseString.endsWith("u") ? timeBaseString.substring(0, timeBaseString.length() - 1) : timeBaseString;
                double timeBaseNumber = Double.parseDouble(str);
                this.timebase = this.preferPeriods ? IrCoreUtils.seconds2microseconds(timeBaseNumber / ModulatedIrSequence.getFrequencyWithDefault(frequency)) : timeBaseNumber;
            }
        }

        Burst.Preferences getBurstPrefs() {
            return this.burstPrefs;
        }

        public int getNoBitsLimit(int noPayload) {
            int tableLimit = this.parameterWidths == null || noPayload >= this.parameterWidths.size() ? Integer.MAX_VALUE : this.parameterWidths.get(noPayload);
            return Math.min(this.maxParameterWidth, tableLimit);
        }

        public BitDirection getBitDirection() {
            return this.bitDirection;
        }

        public boolean isUseExtents() {
            return this.useExtents;
        }

        public Integer getParameterWidth(int i) {
            return this.parameterWidths.get(i);
        }

        public int getMaxParameterWidth() {
            return this.maxParameterWidth;
        }

        public Double getFrequency() {
            return this.frequency;
        }

        public Double getTimebase() {
            return this.timebase;
        }

        public boolean isPreferPeriods() {
            return this.preferPeriods;
        }

        public GeneralSpec getGeneralSpec(double otherTimebase) {
            return new GeneralSpec(this.bitDirection, otherTimebase, this.frequency);
        }

        public boolean isInvert() {
            return this.invert;
        }

        String mkName(int n) {
            if (n < this.parameterNames.size()) {
                return this.parameterNames.get(n);
            }
            String name = Cleaner.mkName(n - this.parameterNames.size());
            if (this.parameterNames.contains(name)) {
                throw new TooFewParameterNamesException();
            }
            return name;
        }

        public static class TooFewParameterNamesException
        extends RuntimeException {
        }
    }
}

