/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.AbstractBiphaseDecoder;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.DecodeException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.IrStreamItem;

public final class BiphaseWithDoubleToggleDecoder
extends AbstractBiphaseDecoder {
    private final BitSpec doubleLengthBitSpec;
    private final int oneAndAHalf;

    public BiphaseWithDoubleToggleDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params, int half, int full, int oneAndAHalf) {
        super(analyzer, params, half, full, false);
        this.doubleLengthBitSpec = BiphaseWithDoubleToggleDecoder.mkBitSpec(2.0 * this.timebase, this.timebase, params.isInvert(), params.getBurstPrefs());
        this.oneAndAHalf = oneAndAHalf < 2 * full ? oneAndAHalf : Integer.MIN_VALUE;
    }

    public BiphaseWithDoubleToggleDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params) {
        this(analyzer, params, analyzer.getTiming(0), analyzer.getTiming(1), analyzer.getTiming(2));
    }

    @Override
    protected List<IrStreamItem> parse(int beg, int length) throws DecodeException {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(2 * length);
        AbstractDecoder.ParameterData data = new AbstractDecoder.ParameterData();
        int foundStartBits = 0;
        BiphaseWithDoubleToggleState state = BiphaseWithDoubleToggleState.start;
        for (int index = beg; index < beg + length; ++index) {
            int noBitsLimit = this.params.getNoBitsLimit(this.noPayload);
            boolean isFlash = index % 2 == 0;
            boolean useExtent = this.params.isUseExtents() && index == beg + length - 1;
            int time = this.analyzer.getCleanedTime(index);
            boolean isShort = time == this.half;
            boolean isLong = time == this.full;
            boolean isOneAndAHalf = time == this.oneAndAHalf;
            switch (state.ordinal()) {
                case 0: {
                    if (this.startDurations() == 0) {
                        if (!isFlash) {
                            throw new ThisCannotHappenException();
                        }
                        if (isShort) {
                            if (this.params.isInvert()) {
                                data.update(1);
                                state = BiphaseWithDoubleToggleState.zero;
                                break;
                            }
                            state = BiphaseWithDoubleToggleState.pendingFlash;
                            break;
                        }
                        this.saveParameter(data, items, this.params.getBitDirection());
                        data = new AbstractDecoder.ParameterData();
                        items.add(this.newFlash(time));
                        state = BiphaseWithDoubleToggleState.zero;
                        break;
                    }
                    items.add(this.newFlashOrGap(isFlash, time));
                    if (this.params.isInvert() == isFlash) {
                        ++foundStartBits;
                    }
                    if (foundStartBits != this.startDurations()) break;
                    state = BiphaseWithDoubleToggleState.zero;
                    break;
                }
                case 1: {
                    if (!isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(this.params.isInvert());
                    if (isShort) {
                        state = BiphaseWithDoubleToggleState.zero;
                        break;
                    }
                    if (isLong) {
                        state = BiphaseWithDoubleToggleState.pendingFlash;
                        break;
                    }
                    if (isOneAndAHalf) {
                        this.saveParameter(data, items, this.params.getBitDirection());
                        data = new AbstractDecoder.ParameterData();
                        state = BiphaseWithDoubleToggleState.pendingLongFlash;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(this.newFlash(time - this.half));
                    state = BiphaseWithDoubleToggleState.zero;
                    break;
                }
                case 2: {
                    if (isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(!this.params.isInvert());
                    if (isShort) {
                        state = BiphaseWithDoubleToggleState.zero;
                        break;
                    }
                    if (isLong) {
                        state = BiphaseWithDoubleToggleState.pendingGap;
                        break;
                    }
                    if (isOneAndAHalf) {
                        this.saveParameter(data, items, this.params.getBitDirection());
                        data = new AbstractDecoder.ParameterData();
                        state = BiphaseWithDoubleToggleState.pendingLongGap;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(useExtent ? this.newExtent(this.analyzer.getTotalDuration(beg, length - 1) + time - this.half) : this.newGap(time - this.half));
                    state = BiphaseWithDoubleToggleState.zero;
                    break;
                }
                case 5: {
                    if (!isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(this.params.isInvert());
                    this.saveParameter(this.doubleLengthBitSpec, data, items, this.params.getBitDirection(), false);
                    data = new AbstractDecoder.ParameterData();
                    if (isLong) {
                        state = BiphaseWithDoubleToggleState.zero;
                        break;
                    }
                    if (isOneAndAHalf) {
                        state = BiphaseWithDoubleToggleState.pendingFlash;
                        break;
                    }
                    throw new DecodeException(index);
                }
                case 4: {
                    if (isFlash) {
                        throw new ThisCannotHappenException();
                    }
                    data.update(!this.params.isInvert());
                    this.saveParameter(this.doubleLengthBitSpec, data, items, this.params.getBitDirection(), false);
                    data = new AbstractDecoder.ParameterData();
                    if (isLong) {
                        state = BiphaseWithDoubleToggleState.zero;
                        break;
                    }
                    if (isOneAndAHalf) {
                        state = BiphaseWithDoubleToggleState.pendingGap;
                        break;
                    }
                    throw new DecodeException(index);
                }
                case 3: {
                    if (isShort) {
                        state = isFlash ? BiphaseWithDoubleToggleState.pendingFlash : BiphaseWithDoubleToggleState.pendingGap;
                        break;
                    }
                    if (isLong && index > 1) {
                        this.saveParameter(data, items, this.params.getBitDirection());
                        data = new AbstractDecoder.ParameterData();
                        state = isFlash ? BiphaseWithDoubleToggleState.pendingLongFlash : BiphaseWithDoubleToggleState.pendingLongGap;
                        break;
                    }
                    this.saveParameter(data, items, this.params.getBitDirection());
                    data = new AbstractDecoder.ParameterData();
                    items.add(isFlash ? this.newFlash(time) : (useExtent ? this.newExtent(this.analyzer.getTotalDuration(beg, length - 1) + time) : this.newGap(time)));
                    break;
                }
                default: {
                    throw new ThisCannotHappenException();
                }
            }
            if (data.getNoBits() < noBitsLimit) continue;
            this.saveParameter(data, items, this.params.getBitDirection());
            data = new AbstractDecoder.ParameterData();
        }
        this.saveParameter(data, items, this.params.getBitDirection());
        return items;
    }

    @Override
    protected int startDurations() {
        return 0;
    }

    private static enum BiphaseWithDoubleToggleState {
        start,
        pendingGap,
        pendingFlash,
        zero,
        pendingLongFlash,
        pendingLongGap;

    }
}

