/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Extent;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.IrStreamItem;

public final class Burst {
    private final int gapDuration;
    private final int flashDuration;

    static Integer multiplier(double us, Double timebase, Preferences prefs) {
        if (timebase == null) {
            return null;
        }
        double units = us / timebase;
        int rounded = (int)Math.round(units);
        double roundingError = (double)Math.round(units) - units;
        boolean ok = units < prefs.getMaxUnits() && Math.abs(roundingError) < prefs.getMaxRoundingError();
        return ok ? Integer.valueOf(rounded) : null;
    }

    private static String unitString(Integer mult, double us, Preferences prefs) {
        return mult != null ? "" : (us < prefs.getMaxMicroSeconds() ? "u" : "m");
    }

    private static Duration newFlashOrGap(boolean isFlash, double us, Double timebase, Preferences prefs) {
        Integer mult = Burst.multiplier(us, timebase, prefs);
        String unit = Burst.unitString(mult, us, prefs);
        double duration = mult != null ? mult.doubleValue() : (unit.equals("m") ? IrCoreUtils.microseconds2milliseconds(us) : us);
        return isFlash ? new Flash(duration, unit) : new Gap(duration, unit);
    }

    public static Extent newExtent(int us, Double timebase, Preferences prefs) {
        Integer mult = Burst.multiplier(us, timebase, prefs);
        String unit = Burst.unitString(mult, us, prefs);
        double duration = unit.isEmpty() && mult != null ? mult.doubleValue() : (unit.equals("m") ? (double)Math.round(IrCoreUtils.microseconds2milliseconds(us)) : (double)us);
        return new Extent(duration, unit);
    }

    public static Flash newFlash(double duration, Double timebase, Preferences prefs) {
        return (Flash)Burst.newFlashOrGap(true, duration, timebase, prefs);
    }

    public static Gap newGap(double duration, Double timebase, Preferences prefs) {
        return (Gap)Burst.newFlashOrGap(false, duration, timebase, prefs);
    }

    public static int compare(Burst burst1, Burst burst2) {
        return burst1.compare(burst2);
    }

    Burst(int flash, int gap) {
        this.gapDuration = gap;
        this.flashDuration = flash;
    }

    public int getGapDuration() {
        return this.gapDuration;
    }

    public int getFlashDuration() {
        return this.flashDuration;
    }

    public BareIrStream toBareIrStream(double timebase, Preferences prefs) {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(2);
        Flash flash = Burst.newFlash(this.flashDuration, timebase, prefs);
        items.add(flash);
        Gap gap = Burst.newGap(this.gapDuration, timebase, prefs);
        items.add(gap);
        return new BareIrStream(items);
    }

    public String toString() {
        return this.toBareIrStream(0.0, new Preferences()).toIrpString(10);
    }

    public String toString(Preferences prefs) {
        return this.toBareIrStream(0.0, prefs).toIrpString(10);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Burst)) {
            return false;
        }
        return this.flashDuration == ((Burst)obj).flashDuration && this.gapDuration == ((Burst)obj).gapDuration;
    }

    public boolean equalsWithLongGap(Burst burst) {
        return this.flashDuration == burst.flashDuration && this.gapDuration > burst.gapDuration;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.gapDuration;
        hash = 67 * hash + this.flashDuration;
        return hash;
    }

    private int sum() {
        return this.flashDuration + this.gapDuration;
    }

    public int compare(Burst burst) {
        int sumCompare = this.sum() - burst.sum();
        return sumCompare != 0 ? sumCompare : this.flashDuration - burst.flashDuration;
    }

    public int overhang(Burst burst) {
        return this.gapDuration - burst.gapDuration;
    }

    public static final class Preferences {
        public static final double DEFAULT_MAX_ROUNDING_ERROR = 0.3;
        public static final double DEFAULT_MAX_UNITS = 30.0;
        public static final double DEFAULT_MAX_MICROSECONDS = 10000.0;
        private double maxRoundingError = 0.3;
        private double maxUnits = 30.0;
        private double maxMicroSeconds = 10000.0;

        public Preferences(double maxRoundingError, double maxUnits, double maxMicroSeconds) {
            this.maxRoundingError = maxRoundingError;
            this.maxUnits = maxUnits;
            this.maxMicroSeconds = maxMicroSeconds;
        }

        public Preferences() {
            this.maxRoundingError = 0.3;
            this.maxUnits = 30.0;
            this.maxMicroSeconds = 10000.0;
        }

        public String toString() {
            return "{" + Double.toString(this.maxRoundingError) + ", " + Double.toString(this.maxUnits) + ", " + Double.toString(this.maxMicroSeconds) + "}";
        }

        public double getMaxRoundingError() {
            return this.maxRoundingError;
        }

        public double getMaxUnits() {
            return this.maxUnits;
        }

        public double getMaxMicroSeconds() {
            return this.maxMicroSeconds;
        }
    }
}

