/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public class Cleaner {
    private static final Logger logger = Logger.getLogger(Cleaner.class.getName());
    private static final int NUMBEROFINITIALTIMINGSCAPACITY = 20;
    private static final int NO_LETTERS = 26;
    private static final int MAXSPAN = 4;
    private int[] rawData;
    protected List<Integer> timings;
    private HashMap<Integer, HistoPair> rawHistogram;
    private HashMap<Integer, HistoPair> cleanedHistogram;
    protected int[] indexData;
    private int[] sorted;
    private HashMap<Integer, Integer> lookDownTable;
    private List<Integer> gapsSortedAfterFrequency;
    private List<Integer> flashesSortedAfterFrequency;
    private int[] indices;
    private boolean signalMode;

    public static IrSequence clean(IrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        Cleaner cleaner = new Cleaner(irSequence, absoluteTolerance, relativeTolerance);
        return cleaner.toIrSequence();
    }

    public static IrSequence clean(IrSequence irSequence) throws InvalidArgumentException {
        return Cleaner.clean(irSequence, (Double)100.0, (Double)0.3);
    }

    public static ModulatedIrSequence clean(ModulatedIrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        return new ModulatedIrSequence(Cleaner.clean((IrSequence)irSequence, absoluteTolerance, relativeTolerance), irSequence.getFrequency(), irSequence.getDutyCycle());
    }

    public static ModulatedIrSequence clean(ModulatedIrSequence irSequence) throws InvalidArgumentException {
        return Cleaner.clean(irSequence, (Double)100.0, (Double)0.3);
    }

    public static IrSignal clean(IrSignal irSignal, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        ModulatedIrSequence irSequence = irSignal.toModulatedIrSequence(1);
        Cleaner cleaner = new Cleaner(irSequence, absoluteTolerance, relativeTolerance);
        IrSequence cleansed = new IrSequence(cleaner.toDurations());
        return new IrSignal(cleansed, irSignal.getIntroLength(), irSignal.getRepeatLength(), irSignal.getFrequency(), irSignal.getDutyCycle());
    }

    public static String mkName(Integer n) {
        if (n == null || n < 0) {
            throw new IllegalArgumentException("mkName requires a non-negative argument");
        }
        return n >= 26 ? Cleaner.mkName(n / 26) + Cleaner.mkName(n % 26) : new String(new char[]{(char)(65 + n)});
    }

    public Cleaner(IrSequence irSequence) throws InvalidArgumentException {
        this(irSequence, 100.0, 0.3);
    }

    public Cleaner(IrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        this(irSequence.toInts(), new int[]{irSequence.getLength()}, false, absoluteTolerance, relativeTolerance);
    }

    protected Cleaner(int[] data, int[] indices, boolean signalMode, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        for (int x : data) {
            if (x != 0) continue;
            throw new InvalidArgumentException("Data contains duration of length 0");
        }
        this.rawData = data;
        this.indices = indices;
        this.signalMode = signalMode;
        this.createRawHistogram();
        double relTol = IrCoreUtils.getRelativeTolerance(relativeTolerance);
        double absTol = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        ArrayList<Integer> dumbTimings = this.createDumbTimings(absTol, relTol);
        this.improveTimingsTable(dumbTimings, absTol, relTol);
        this.createCookedData();
        this.createCleanHistogram();
        this.createSortedGapsAndFlashes();
    }

    public boolean isSignalMode() {
        return this.signalMode;
    }

    private void createRawHistogram() {
        this.rawHistogram = new HashMap(20);
        for (int i = 0; i < this.rawData.length; ++i) {
            boolean isFlash = i % 2 == 0;
            int duration = this.rawData[i];
            if (!this.rawHistogram.containsKey(duration)) {
                this.rawHistogram.put(duration, new HistoPair());
            }
            this.rawHistogram.get(duration).increment(isFlash);
        }
    }

    private ArrayList<Integer> createDumbTimings(double absoluteTolerance, double relativeTolerance) {
        ArrayList<Integer> dumbTimings = new ArrayList<Integer>(this.rawData.length);
        this.sorted = (int[])this.rawData.clone();
        Arrays.sort(this.sorted);
        int last = -99999;
        for (int d : this.sorted) {
            if (IrCoreUtils.approximatelyEquals(d, last, (int)absoluteTolerance, relativeTolerance)) continue;
            int representative = d;
            dumbTimings.add(representative);
            last = representative;
        }
        return dumbTimings;
    }

    private void improveTimingsTable(List<Integer> dumbTimings, double absoluteTolerance, double relativeTolerance) {
        this.lookDownTable = new HashMap(20);
        this.timings = new ArrayList<Integer>(20);
        int indexInSortedTimings = 0;
        for (int timingsIndex = 0; timingsIndex < dumbTimings.size(); ++timingsIndex) {
            int dumbTiming = dumbTimings.get(timingsIndex);
            long sum = 0L;
            int terms = 0;
            int lastDuration = -1;
            while (indexInSortedTimings < this.sorted.length && IrCoreUtils.approximatelyEquals(dumbTiming, this.sorted[indexInSortedTimings], (int)absoluteTolerance, relativeTolerance)) {
                int duration = this.sorted[indexInSortedTimings];
                ++indexInSortedTimings;
                if (duration == lastDuration) continue;
                lastDuration = duration;
                int noHits = this.rawHistogram.get(duration).total();
                long term = noHits * duration;
                if (term < 0L || (sum += term) < 0L) {
                    throw new ThisCannotHappenException("Internal overflow error!!! Please report.");
                }
                terms += noHits;
                this.lookDownTable.put(duration, timingsIndex);
            }
            int average = (int)Math.round((double)sum / (double)terms);
            this.timings.add(average);
            this.lookDownTable.put(average, timingsIndex);
        }
    }

    private void createCookedData() {
        this.indexData = new int[this.rawData.length];
        for (int i = 0; i < this.rawData.length; ++i) {
            this.indexData[i] = this.lookDownTable.get(this.rawData[i]);
        }
    }

    private void createCleanHistogram() {
        this.cleanedHistogram = new LinkedHashMap<Integer, HistoPair>(20);
        this.timings.stream().forEach(duration -> this.cleanedHistogram.put((Integer)duration, new HistoPair()));
        this.rawHistogram.entrySet().stream().forEach(kvp -> {
            int index = this.lookDownTable.get(kvp.getKey());
            Integer cleanedDuration = this.timings.get(index);
            this.cleanedHistogram.get(cleanedDuration).add((HistoPair)kvp.getValue());
        });
    }

    public String getName(int duration) {
        return Cleaner.mkName(this.getIndex(duration));
    }

    public IrSequence toIrSequence() {
        try {
            return new IrSequence(this.toDurations());
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException();
        }
    }

    private int[] toDurations() {
        return this.toDurations(0, this.rawData.length);
    }

    protected int[] toDurations(int beg, int length) {
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.timings.get(this.indexData[beg + i]);
        }
        return data;
    }

    protected String toTimingsString(int beg, int length) {
        StringJoiner str = new StringJoiner(" ");
        for (int i = 0; i < length; i += 2) {
            StringBuilder s = new StringBuilder(2);
            s.append(Cleaner.mkName(this.indexData[beg + i]));
            s.append(Cleaner.mkName(this.indexData[beg + i + 1]));
            str.add(s);
        }
        return str.toString();
    }

    public String toTimingsString() {
        return this.toTimingsString(0, this.rawData.length);
    }

    protected int getTotalDuration(int beg, int length) {
        int sum = 0;
        for (int i = beg; i < beg + length; ++i) {
            sum += this.timings.get(this.indexData[i]).intValue();
        }
        return sum;
    }

    public int getTiming(int index) {
        return this.timings.get(index);
    }

    public Integer getIndex(int duration) {
        return this.lookDownTable.get(duration);
    }

    private List<Integer> getFalshesOrGaps(boolean isFlash) {
        ArrayList<Integer> list = new ArrayList<Integer>(this.timings.size());
        this.timings.stream().filter(d -> this.cleanedHistogram.get(d).get(isFlash) > 0).forEach(d -> list.add((Integer)d));
        return list;
    }

    public List<Integer> getGaps() {
        return this.getFalshesOrGaps(false);
    }

    public List<Integer> getFlashes() {
        return this.getFalshesOrGaps(true);
    }

    public HashMap<Integer, Integer> getCleanedHistogram() {
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>(this.cleanedHistogram.size());
        this.cleanedHistogram.entrySet().stream().forEach(kvp -> result.put((Integer)kvp.getKey(), ((HistoPair)kvp.getValue()).total()));
        return result;
    }

    public int getNumberGaps(int duration) {
        return this.cleanedHistogram.get((Object)Integer.valueOf((int)duration)).numberGaps;
    }

    public int getNumberFlashes(int duration) {
        return this.cleanedHistogram.get((Object)Integer.valueOf((int)duration)).numberFlashes;
    }

    public int getNumberPairs(int flash, int gap) {
        Integer igap = this.getIndex(gap);
        Integer iflash = this.getIndex(flash);
        if (igap == null || iflash == null) {
            throw new ThisCannotHappenException();
        }
        int result = 0;
        for (int i = 0; i < this.indexData.length - 1; i += 2) {
            if (this.indexData[i] != iflash || this.indexData[i + 1] != igap) continue;
            ++result;
        }
        return result;
    }

    private void createSortedGapsAndFlashes() {
        this.gapsSortedAfterFrequency = this.getFalshesOrGaps(false);
        Collections.sort(this.gapsSortedAfterFrequency, (a, b) -> this.cleanedHistogram.get((Object)b).numberGaps - this.cleanedHistogram.get((Object)a).numberGaps);
        this.flashesSortedAfterFrequency = this.getFalshesOrGaps(true);
        Collections.sort(this.flashesSortedAfterFrequency, (a, b) -> this.cleanedHistogram.get((Object)b).numberFlashes - this.cleanedHistogram.get((Object)a).numberFlashes);
    }

    public int getGapsSortedAfterFrequency(int i) {
        return this.gapsSortedAfterFrequency.get(i);
    }

    public int getFlashesSortedAfterFrequency(int i) {
        return this.flashesSortedAfterFrequency.get(i);
    }

    public int getNumberOfGaps() {
        return this.gapsSortedAfterFrequency.size();
    }

    public int getNumberOfFlashes() {
        return this.flashesSortedAfterFrequency.size();
    }

    protected int getSequenceBegin(int n) {
        return n == 0 ? 0 : this.indices[n - 1];
    }

    protected int getSequenceLength(int n) {
        return this.indices[n] - (n > 0 ? this.indices[n - 1] : 0);
    }

    public int[] toDurations(int nr) {
        return this.toDurations(this.getSequenceBegin(nr), this.getSequenceLength(nr));
    }

    public IrSequence cleanedIrSequence(int nr) {
        try {
            return new IrSequence(this.toDurations(nr));
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public List<IrSequence> cleanedIrSequences() {
        ArrayList<IrSequence> list = new ArrayList<IrSequence>(this.getNoSequences());
        for (int i = 0; i < this.getNoSequences(); ++i) {
            list.add(this.cleanedIrSequence(i));
        }
        return list;
    }

    public String toTimingsString(int nr) {
        return this.toTimingsString(this.getSequenceBegin(nr), this.getSequenceLength(nr));
    }

    public int getCleanedTime(int i) {
        return this.timings.get(this.indexData[i]);
    }

    public int getNoSequences() {
        return this.signalMode ? 1 : this.indices.length;
    }

    protected int getTimeBaseFromData(double relativeTolerance) {
        Integer min = this.timings.get(0);
        if (min == 0) {
            throw new ThisCannotHappenException("min == 0");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.timings.size());
        StringBuilder str = new StringBuilder(5 * this.timings.size());
        this.timings.forEach(time -> {
            int numberOccurances = this.cleanedHistogram.get(time).total();
            int span = time / min;
            if (numberOccurances > 1 && span <= 4) {
                list.add((Integer)time);
                str.append(" ").append(time);
            }
        });
        if (list.isEmpty()) {
            logger.log(Level.FINE, "Cannot find a sensible time base");
            return 1;
        }
        int gcd = IrCoreUtils.approximateGreatestCommonDivider(list, relativeTolerance);
        logger.log(Level.FINER, "Computing GCD of {0} to {1}", new Object[]{str.toString(), gcd});
        return gcd;
    }

    private static class HistoPair {
        int numberGaps = 0;
        int numberFlashes = 0;

        HistoPair() {
        }

        int get(boolean isFlash) {
            return isFlash ? this.numberFlashes : this.numberGaps;
        }

        void increment(boolean isFlash) {
            if (isFlash) {
                ++this.numberFlashes;
            } else {
                ++this.numberGaps;
            }
        }

        int total() {
            return this.numberFlashes + this.numberGaps;
        }

        public String toString() {
            return this.total() + "=" + this.numberGaps + "+" + this.numberFlashes;
        }

        private void add(HistoPair op) {
            this.numberGaps += op.numberGaps;
            this.numberFlashes += op.numberFlashes;
        }
    }
}

