/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.Cleaner;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultiParser;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public class CleanerParser
extends MultiParser {
    private final double absoluteTolerance;
    private final double relativeTolerance;
    private Cleaner cleaner = null;

    public CleanerParser(List<IrSignalParser> parsers, String source, Double absoluteTolerance, Double relativeTolerance) {
        super(parsers, source);
        this.absoluteTolerance = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        this.relativeTolerance = IrCoreUtils.getRelativeTolerance(relativeTolerance);
    }

    public CleanerParser(List<IrSignalParser> parsers, Iterable<? extends CharSequence> args, Double absoluteTolerance, Double relativeTolerance) {
        super(parsers, args);
        this.absoluteTolerance = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        this.relativeTolerance = IrCoreUtils.getRelativeTolerance(relativeTolerance);
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    @Override
    public IrSequence toIrSequence(Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        IrSequence irSequence = super.toIrSequence(dummyGap);
        this.cleaner = new Cleaner(irSequence, this.absoluteTolerance, this.relativeTolerance);
        return this.cleaner.toIrSequence();
    }

    @Override
    public List<IrSequence> toList(Double dummmyGap) throws OddSequenceLengthException, InvalidArgumentException {
        List<IrSequence> list = super.toList(dummmyGap);
        return this.clean(list);
    }

    @Override
    public List<IrSequence> toListChop(double threshold, Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        List<IrSequence> list = super.toListChop(threshold, dummyGap);
        return this.clean(list);
    }

    private List<IrSequence> clean(List<IrSequence> list) throws InvalidArgumentException {
        IrSequence total = IrSequence.concatenate(list);
        this.cleaner = new Cleaner(total, this.absoluteTolerance, this.relativeTolerance);
        IrSequence cleanedTotal = this.cleaner.toIrSequence();
        ArrayList<IrSequence> result = new ArrayList<IrSequence>(list.size());
        int pos = 0;
        for (IrSequence seq : list) {
            int length = seq.getLength();
            try {
                IrSequence segment = cleanedTotal.subSequence(pos, length);
                result.add(segment);
                pos += length;
            }
            catch (InvalidArgumentException ex) {
                throw new ThisCannotHappenException();
            }
        }
        return result;
    }

    @Override
    public ModulatedIrSequence toModulatedIrSequence(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        ModulatedIrSequence irSequence = super.toModulatedIrSequence(fallbackFrequency, dummyGap);
        this.cleaner = new Cleaner(irSequence, this.absoluteTolerance, this.relativeTolerance);
        return new ModulatedIrSequence(this.cleaner.toIrSequence(), irSequence.getFrequency());
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        IrSignal irSignal = super.toIrSignal(fallbackFrequency, dummyGap);
        return this.clean(irSignal);
    }

    @Override
    public IrSignal toIrSignalChop(Double fallbackFrequency, double threshold) throws OddSequenceLengthException, InvalidArgumentException {
        IrSignal irSignal = super.toIrSignalChop(fallbackFrequency, threshold);
        return this.clean(irSignal);
    }

    private IrSignal clean(IrSignal irSignal) throws InvalidArgumentException {
        if (irSignal == null) {
            return null;
        }
        ModulatedIrSequence irSequence = irSignal.toModulatedIrSequence();
        this.cleaner = new Cleaner(irSequence, this.absoluteTolerance, this.relativeTolerance);
        IrSequence cleansed = this.cleaner.toIrSequence();
        return new IrSignal(cleansed, irSignal.getIntroLength(), irSignal.getRepeatLength(), irSignal.getFrequency(), irSignal.getDutyCycle());
    }
}

