/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.List;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.DecodeException;
import org.harctoolbox.analyze.PwmDecoder;
import org.harctoolbox.irp.NonUniqueBitCodeException;

public final class Pwm4Decoder
extends PwmDecoder {
    private static final int NO_BURSTS = 4;

    private static Burst[] mkBursts(int flash, int zeroGap, int oneGap, int twoGap, int threeGap) {
        return Pwm4Decoder.mkBursts(new Burst(flash, zeroGap), new Burst(flash, oneGap), new Burst(flash, twoGap), new Burst(flash, threeGap));
    }

    private static Burst[] mkBursts(Analyzer analyzer) throws DecodeException {
        if (analyzer.getNumberOfGaps() < 4) {
            throw new DecodeException();
        }
        int flash = analyzer.getFlashes().get(0);
        List<Integer> gaps = analyzer.getGaps();
        return Pwm4Decoder.mkBursts(flash, gaps.get(0), gaps.get(1), gaps.get(2), gaps.get(3));
    }

    public Pwm4Decoder(Analyzer analyzer, Analyzer.AnalyzerParams params, Burst zero, Burst one, Burst two, Burst three) throws NonUniqueBitCodeException {
        super(analyzer, params, Pwm4Decoder.mkBursts(zero, one, two, three));
    }

    public Pwm4Decoder(Analyzer analyzer, Analyzer.AnalyzerParams params, int flash, int zeroGap, int oneGap, int twoGap, int threeGap) throws NonUniqueBitCodeException {
        this(analyzer, params, new Burst(flash, zeroGap), new Burst(flash, oneGap), new Burst(flash, twoGap), new Burst(flash, threeGap));
    }

    public Pwm4Decoder(Analyzer analyzer, Analyzer.AnalyzerParams params) throws DecodeException, NonUniqueBitCodeException {
        super(analyzer, params, Pwm4Decoder.mkBursts(analyzer));
    }
}

