/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.NonUniqueBitCodeException;

public abstract class PwmDecoder
extends AbstractDecoder {
    private final Burst[] bursts;
    private final int chunksize;
    private final boolean distinctFlashesInBursts;

    private static BitSpec mkBitSpec(Burst[] bursts, double timebase, Burst.Preferences burstPrefs) throws NonUniqueBitCodeException {
        ArrayList<BareIrStream> list = new ArrayList<BareIrStream>(bursts.length);
        for (Burst burst : bursts) {
            list.add(burst.toBareIrStream(timebase, burstPrefs));
        }
        return new BitSpec(list);
    }

    protected static Burst[] mkBursts(Burst ... bursts) {
        return bursts;
    }

    public PwmDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params, Burst[] bursts) throws NonUniqueBitCodeException {
        super(analyzer, params);
        this.bursts = new Burst[bursts.length];
        for (int i = 0; i < bursts.length; ++i) {
            this.bursts[i] = bursts[params.isInvert() ? bursts.length - i - 1 : i];
        }
        this.distinctFlashesInBursts = this.setupDistinctFlashesInBursts();
        this.chunksize = (int)IrCoreUtils.log2(bursts.length);
        this.bitSpec = PwmDecoder.mkBitSpec(this.bursts, this.timebase, params.getBurstPrefs());
    }

    public boolean hasDistinctFlashesInBursts() {
        return this.distinctFlashesInBursts;
    }

    private boolean setupDistinctFlashesInBursts() {
        ArrayList<Integer> flashes = new ArrayList<Integer>(this.bursts.length);
        for (Burst burst : this.bursts) {
            int flash = burst.getFlashDuration();
            if (flashes.contains(flash)) {
                return false;
            }
            flashes.add(flash);
        }
        return true;
    }

    @Override
    protected List<IrStreamItem> parse(int beg, int length) {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(16);
        int noBitsLimit = Integer.MAX_VALUE;
        AbstractDecoder.ParameterData data = new AbstractDecoder.ParameterData(this.chunksize);
        for (int i = beg; i < beg + length - 1; i += 2) {
            int n;
            noBitsLimit = this.params.getNoBitsLimit(this.noPayload);
            int flash = this.analyzer.getCleanedTime(i);
            int gap = this.analyzer.getCleanedTime(i + 1);
            Burst burst = new Burst(flash, gap);
            boolean hit = false;
            for (n = 0; !hit && n < this.bursts.length; ++n) {
                if (!burst.equals(this.bursts[n])) continue;
                data.update(n);
                hit = true;
            }
            int overhang = 0;
            if (!hit) {
                if (this.hasDistinctFlashesInBursts() && !data.isEmpty()) {
                    for (n = 0; !hit && n < this.bursts.length; ++n) {
                        if (!burst.equalsWithLongGap(this.bursts[n])) continue;
                        data.update(n);
                        hit = true;
                        overhang = burst.overhang(this.bursts[n]);
                    }
                }
                while (!data.isEmpty()) {
                    this.dumpParameters(data, items, noBitsLimit);
                }
                if (overhang == 0) {
                    items.add(this.newFlash(flash));
                    if (i == beg + length - 2 && this.params.isUseExtents()) {
                        items.add(this.newExtent(this.analyzer.getTotalDuration(beg, length)));
                    } else {
                        items.add(this.newGap(gap));
                    }
                } else if (i == beg + length - 2 && this.params.isUseExtents()) {
                    items.add(this.newExtent(this.analyzer.getTotalDuration(beg, length) - gap));
                } else {
                    items.add(this.newGap(overhang));
                }
            }
            while (data.getNoBits() >= noBitsLimit) {
                this.dumpParameters(data, items, noBitsLimit);
            }
        }
        while (!data.isEmpty()) {
            this.dumpParameters(data, items, noBitsLimit);
        }
        return items;
    }
}

