/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import org.harctoolbox.analyze.Cleaner;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public final class RepeatFinder {
    private static double defaultMinRepeatLastGap = 5000.0;
    private static double defaultRelativeTolerance = 0.3;
    private static double defaultAbsoluteTolerance = 100.0;
    private double relativeTolerance;
    private double absoluteTolerance;
    private double minRepeatLastGap;
    private IrSequence irSequence;
    private RepeatFinderData repeatFinderData;

    public static double getDefaultMinRepeatLastGap() {
        return defaultMinRepeatLastGap;
    }

    public static void setDefaultMinRepeatLastGap(double aDefaultMinRepeatLastGap) {
        defaultMinRepeatLastGap = aDefaultMinRepeatLastGap;
    }

    public static double getDefaultRelativeTolerance() {
        return defaultRelativeTolerance;
    }

    public static void setDefaultRelativeTolerance(double aDefaultRelativeTolerance) {
        defaultRelativeTolerance = aDefaultRelativeTolerance;
    }

    public static double getDefaultAbsoluteTolerance() {
        return defaultAbsoluteTolerance;
    }

    public static void setDefaultAbsoluteTolerance(double aDefaultAbsoluteTolerance) {
        defaultAbsoluteTolerance = aDefaultAbsoluteTolerance;
    }

    public static IrSignal findRepeat(ModulatedIrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) {
        RepeatFinder repeatFinder = new RepeatFinder(irSequence, absoluteTolerance, relativeTolerance);
        return repeatFinder.toIrSignal(irSequence);
    }

    public static IrSignal findRepeat(ModulatedIrSequence irSequence) {
        return RepeatFinder.findRepeat(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    public static IrSignal findRepeatClean(ModulatedIrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) throws InvalidArgumentException {
        RepeatFinder repeatFinder = new RepeatFinder(irSequence, absoluteTolerance, relativeTolerance);
        return repeatFinder.toIrSignalClean(irSequence);
    }

    public static IrSignal findRepeatClean(ModulatedIrSequence irSequence) throws InvalidArgumentException {
        return RepeatFinder.findRepeatClean(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    public RepeatFinder(IrSequence irSequence, Double absoluteTolerance, Double relativeTolerance, Double minRepeatLastGap) {
        if (irSequence == null) {
            throw new NullPointerException("IrSequence must be non-null.");
        }
        this.absoluteTolerance = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        this.relativeTolerance = IrCoreUtils.getRelativeTolerance(relativeTolerance);
        this.minRepeatLastGap = IrCoreUtils.getMinRepeatLastGap(minRepeatLastGap);
        this.irSequence = irSequence;
        try {
            this.analyze();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RepeatFinder(IrSequence irSequence, Double absoluteTolerance, Double relativeTolerance) {
        this(irSequence, absoluteTolerance, relativeTolerance, defaultMinRepeatLastGap);
    }

    public RepeatFinder(IrSequence irSequence) {
        this(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    public RepeatFinder(int[] data) throws OddSequenceLengthException {
        this(new IrSequence(data), defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    private void analyze() {
        RepeatFinderData candidate = new RepeatFinderData(this.irSequence.getLength());
        for (int length = this.irSequence.getLength() / 4; length >= 2; --length) {
            for (int beginning = 0; beginning < this.irSequence.getLength() / 2 - length; ++beginning) {
                RepeatFinderData newCandidate;
                try {
                    newCandidate = this.countRepeats(2 * beginning, 2 * length);
                }
                catch (OddSequenceLengthException ex) {
                    throw new ThisCannotHappenException();
                }
                if (newCandidate.numberRepeats <= 1 || !(newCandidate.lastGap > this.minRepeatLastGap) || !(newCandidate.repeatsDuration > candidate.repeatsDuration - 0.1)) continue;
                candidate = newCandidate;
            }
        }
        this.repeatFinderData = candidate;
    }

    private RepeatFinderData countRepeats(int beginning, int length) throws OddSequenceLengthException {
        RepeatFinderData result = new RepeatFinderData(beginning, length, 0, 0);
        result.lastGap = Math.abs(this.irSequence.get(beginning + length - 1));
        if (result.lastGap < this.minRepeatLastGap) {
            return result;
        }
        int hits = 1;
        while (true) {
            boolean hit;
            if (!(hit = this.compareSubSequences(beginning, beginning + hits * length, length))) {
                result.numberRepeats = hits;
                result.endingLength = this.irSequence.getLength() - beginning - hits * length;
                result.repeatsDuration = this.irSequence.getTotalDuration(beginning, hits * length);
                return result;
            }
            ++hits;
        }
    }

    private boolean compareSubSequences(int beginning, int compareStart, int length) {
        if (compareStart + length > this.irSequence.getLength()) {
            return false;
        }
        return this.irSequence.approximatelyEquals(beginning, compareStart, length, this.absoluteTolerance, this.relativeTolerance, this.minRepeatLastGap);
    }

    public IrSignal toIrSignal(IrSequence irSequence, double frequency) {
        return this.repeatFinderData.chopIrSequence(new ModulatedIrSequence(irSequence, (Double)frequency));
    }

    public IrSignal toIrSignal(ModulatedIrSequence irSequence) {
        return this.repeatFinderData.chopIrSequence(irSequence);
    }

    public IrSignal toIrSignalClean(ModulatedIrSequence irSequence) throws InvalidArgumentException {
        return this.repeatFinderData.chopIrSequence(Cleaner.clean(irSequence, (Double)this.absoluteTolerance, (Double)this.relativeTolerance));
    }

    public RepeatFinderData getRepeatFinderData() {
        return this.repeatFinderData;
    }

    public static class RepeatFinderData {
        private int beginLength;
        private int repeatLength;
        private int numberRepeats;
        private int endingLength;
        private double lastGap;
        private double repeatsDuration;

        public RepeatFinderData(int length) {
            this.setup(length, 0, 0, 0);
        }

        public RepeatFinderData(int beginLength, int repeatLength, int numberRepeats, int endingLength) throws OddSequenceLengthException {
            if (beginLength % 2 != 0 || repeatLength % 2 != 0 || endingLength % 2 != 0) {
                throw new OddSequenceLengthException("Lengths and start must be even");
            }
            this.setup(beginLength, repeatLength, numberRepeats, endingLength);
        }

        private void setup(int beginLength, int repeatLength, int numberRepeats, int endingLength) {
            this.beginLength = beginLength;
            this.repeatLength = repeatLength;
            this.numberRepeats = numberRepeats;
            this.endingLength = endingLength;
            this.lastGap = 0.0;
            this.repeatsDuration = 0.0;
        }

        public String toString() {
            return "beginLength = " + this.beginLength + "; repeatLength = " + this.repeatLength + "; numberRepeats = " + this.numberRepeats + "; endingLength = " + this.endingLength + "; totalLength = " + this.totalLength() + "; repeatsDuration = " + this.repeatsDuration;
        }

        public int getBeginLength() {
            return this.beginLength;
        }

        public int getNumberRepeats() {
            return this.numberRepeats;
        }

        public int getRepeatLength() {
            return this.repeatLength;
        }

        public int getEndingLength() {
            return this.endingLength;
        }

        public int getEndingStart() {
            return this.beginLength + this.numberRepeats * this.repeatLength;
        }

        private int totalLength() {
            return this.beginLength + this.numberRepeats * this.repeatLength + this.endingLength;
        }

        public IrSignal chopIrSequence(ModulatedIrSequence irSequence) {
            try {
                return this.numberRepeats > 1 ? new IrSignal(irSequence, this.beginLength, this.repeatLength, this.numberRepeats) : new IrSignal(irSequence);
            }
            catch (InvalidArgumentException ex) {
                assert (false);
                return null;
            }
        }
    }
}

