/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.List;
import org.harctoolbox.analyze.RepeatFinder;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultiParser;

public class RepeatFinderParser
extends MultiParser {
    private final double absoluteTolerance;
    private final double relativeTolerance;
    private final double minRepeatLastGap;
    private RepeatFinder repeatFinder = null;

    public RepeatFinderParser(List<IrSignalParser> parsers, String source) {
        this(parsers, source, null, null, null);
    }

    public RepeatFinderParser(List<IrSignalParser> parsers, String source, Double absoluteTolerance, Double relativeTolerance, Double minRepeatLastGap) {
        super(parsers, source);
        this.absoluteTolerance = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        this.relativeTolerance = IrCoreUtils.getRelativeTolerance(relativeTolerance);
        this.minRepeatLastGap = IrCoreUtils.getMinRepeatLastGap(minRepeatLastGap);
    }

    public RepeatFinderParser(Iterable<? extends CharSequence> args) {
        this(args, null, null, null);
    }

    public RepeatFinderParser(Iterable<? extends CharSequence> args, Double absoluteTolerance, Double relativeTolerance, Double minRepeatLastGap) {
        super(args);
        this.absoluteTolerance = IrCoreUtils.getAbsoluteTolerance(absoluteTolerance);
        this.relativeTolerance = IrCoreUtils.getRelativeTolerance(relativeTolerance);
        this.minRepeatLastGap = IrCoreUtils.getMinRepeatLastGap(minRepeatLastGap);
    }

    public RepeatFinder getRepeatFinder() {
        return this.repeatFinder;
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        return this.toIrSignalAux(fallbackFrequency, dummyGap, false);
    }

    public IrSignal toIrSignalClean(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        return this.toIrSignalAux(fallbackFrequency, dummyGap, true);
    }

    public IrSignal toIrSignalClean() throws InvalidArgumentException {
        return this.toIrSignalAux(null, null, true);
    }

    private IrSignal toIrSignalAux(Double fallbackFrequency, Double dummyGap, boolean clean) throws InvalidArgumentException {
        ModulatedIrSequence modulatedIrSequence;
        IrSignal irSignal = super.toIrSignal(fallbackFrequency, dummyGap);
        if (irSignal != null && irSignal.getRepeatLength() > 0) {
            return irSignal;
        }
        ModulatedIrSequence modulatedIrSequence2 = modulatedIrSequence = irSignal != null ? irSignal.toModulatedIrSequence() : this.toModulatedIrSequence(fallbackFrequency, dummyGap);
        if (modulatedIrSequence == null) {
            return null;
        }
        this.repeatFinder = new RepeatFinder(modulatedIrSequence, this.absoluteTolerance, this.relativeTolerance, this.minRepeatLastGap);
        return clean ? this.repeatFinder.toIrSignalClean(modulatedIrSequence) : this.repeatFinder.toIrSignal(modulatedIrSequence);
    }
}

