/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.NonUniqueBitCodeException;

public final class SerialDecoder
extends AbstractDecoder {
    private static BitSpec mkBitSpec(boolean invert) throws NonUniqueBitCodeException {
        Flash on = new Flash(1.0, null);
        Gap off = new Gap(1.0, null);
        ArrayList<IrStreamItem> listOn = new ArrayList<IrStreamItem>(1);
        listOn.add(on);
        ArrayList<IrStreamItem> listOff = new ArrayList<IrStreamItem>(1);
        listOff.add(off);
        ArrayList<BareIrStream> list = new ArrayList<BareIrStream>(2);
        if (invert) {
            list.add(new BareIrStream(listOn));
            list.add(new BareIrStream(listOff));
        } else {
            list.add(new BareIrStream(listOff));
            list.add(new BareIrStream(listOn));
        }
        return new BitSpec(list);
    }

    public SerialDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params) throws NonUniqueBitCodeException {
        super(analyzer, params);
        this.bitSpec = SerialDecoder.mkBitSpec(params.isInvert());
    }

    @Override
    protected List<IrStreamItem> parse(int beg, int length) {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(8);
        AbstractDecoder.ParameterData data = new AbstractDecoder.ParameterData();
        int noBitsLimit = Integer.MAX_VALUE;
        for (int index = beg; index < beg + length; ++index) {
            int time;
            noBitsLimit = this.params.getNoBitsLimit(this.noPayload);
            boolean isFlash = index % 2 == 0;
            Duration duration = this.newFlashOrGap(isFlash, time = this.analyzer.getCleanedTime(index));
            if (duration.getUnit().isEmpty()) {
                int noBits;
                try {
                    noBits = (int)Math.round(duration.getTimeInUnits());
                }
                catch (InvalidArgumentException ex) {
                    throw new ThisCannotHappenException(ex);
                }
                int amount = isFlash ? (int)IrCoreUtils.ones(noBits) : 0;
                data.update(amount, noBits);
            } else {
                while (!data.isEmpty()) {
                    this.dumpParameters(data, items, noBitsLimit, this.params.isInvert());
                }
                if (index == beg + length - 1 && this.params.isUseExtents()) {
                    items.add(this.newExtent(this.analyzer.getTotalDuration(beg, length)));
                } else {
                    items.add(duration);
                }
            }
            while (data.getNoBits() >= noBitsLimit) {
                this.dumpParameters(data, items, noBitsLimit, this.params.isInvert());
            }
        }
        while (!data.isEmpty()) {
            this.dumpParameters(data, items, noBitsLimit, this.params.isInvert());
        }
        return items;
    }
}

