/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.irp.IrStreamItem;

public final class TrivialDecoder
extends AbstractDecoder {
    public TrivialDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params) {
        super(analyzer, params);
    }

    @Override
    protected List<IrStreamItem> parse(int beg, int length) {
        ArrayList<IrStreamItem> items = new ArrayList<IrStreamItem>(length);
        for (int i = beg; i < beg + length - 1; i += 2) {
            int gap = this.analyzer.getCleanedTime(i);
            int flash = this.analyzer.getCleanedTime(i + 1);
            items.add(this.newFlash(gap));
            if (i == beg + length - 2 && this.params.isUseExtents()) {
                items.add(this.newExtent(this.analyzer.getTotalDuration(beg, length)));
                continue;
            }
            items.add(this.newGap(flash));
        }
        return items;
    }
}

