/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.analyze;

import java.util.List;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.PwmDecoder;
import org.harctoolbox.irp.NonUniqueBitCodeException;

public final class XmpDecoder
extends PwmDecoder {
    private static final int NO_BURSTS = 16;

    private static Burst[] mkBursts(int flash, int gapsBase, int delta) {
        Burst[] array = new Burst[16];
        for (int n = 0; n < 16; ++n) {
            Burst burst;
            array[n] = burst = new Burst(flash, gapsBase + n * delta);
        }
        return array;
    }

    private static Burst[] mkBursts(Analyzer analyzer) {
        int flash = analyzer.getFlashes().get(0);
        List<Integer> gaps = analyzer.getGaps();
        int gapsBase = gaps.get(0);
        int delta = Integer.MAX_VALUE;
        for (int i = 0; i < gaps.size() - 1; ++i) {
            int diff = gaps.get(i + 1) - gaps.get(i);
            delta = Math.min(delta, diff);
        }
        return XmpDecoder.mkBursts(flash, gapsBase, delta);
    }

    public XmpDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params, int flash, int gapsBase, int delta) throws NonUniqueBitCodeException {
        super(analyzer, params, XmpDecoder.mkBursts(flash, gapsBase, delta));
    }

    public XmpDecoder(Analyzer analyzer, Analyzer.AnalyzerParams params) throws NonUniqueBitCodeException {
        super(analyzer, params, XmpDecoder.mkBursts(analyzer));
    }
}

