/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import java.util.Locale;
import org.harctoolbox.cmdline.CmdLineProgram;
import org.harctoolbox.ircore.IrCoreUtils;

public abstract class AbstractCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Print help for this command.")
    protected boolean helpRequested = false;
    @Parameter(names={"--describe"}, help=true, description="Print a possibly longer documentation for the present command.")
    private boolean description = false;

    public String description() {
        return "Documentation for this command has not yet been written.\nUse --help for the syntax of the command.";
    }

    public boolean process(CmdLineProgram instance) {
        if (this.helpRequested) {
            instance.usage(this.getClass().getSimpleName().substring(7).toLowerCase(Locale.US));
            return true;
        }
        if (this.description) {
            IrCoreUtils.trivialFormatter(instance.getOutputStream(), this.description(), 65);
            return true;
        }
        return false;
    }
}

