/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandBasicOptions;
import org.harctoolbox.cmdline.CommandHelp;
import org.harctoolbox.cmdline.ProgramExitStatus;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.IrCoreUtils;

public abstract class CmdLineProgram {
    protected PrintStream out;
    protected final JCommander argumentParser;
    protected final CommandHelp commandHelp;
    protected String[] originalArguments;
    protected final CommandBasicOptions commandBasicOptions;
    protected String command;
    private final String progName;

    protected CmdLineProgram(PrintStream out, CommandBasicOptions commandLineArgs, String progName) {
        this.out = out;
        this.progName = progName;
        this.commandBasicOptions = commandLineArgs;
        this.argumentParser = new JCommander(commandLineArgs);
        this.argumentParser.setProgramName(progName);
        this.argumentParser.setAllowAbbreviatedOptions(true);
        this.commandHelp = new CommandHelp();
        this.argumentParser.addCommand(this.commandHelp);
    }

    protected CmdLineProgram(CommandBasicOptions commandLineArgs, String progName) {
        this(System.out, commandLineArgs, progName);
    }

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public void usage(String command) {
        CommandHelp.usage(this.out, command, this.argumentParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ProgramExitStatus run(String[] args) {
        try {
            try {
                this.parseArgs(args);
                this.setupLoggers();
            }
            catch (ParameterException | FileNotFoundException | UnsupportedEncodingException | UsageException ex) {
                ProgramExitStatus programExitStatus = new ProgramExitStatus(this.progName, 1, ex.getLocalizedMessage());
                this.out.close();
                return programExitStatus;
            }
            catch (IOException ex) {
                ProgramExitStatus programExitStatus = new ProgramExitStatus(this.progName, 3, ex.getLocalizedMessage());
                this.out.close();
                return programExitStatus;
            }
            this.extraSetup();
            ProgramExitStatus status = this.processHelpAndDescription();
            if (status != null) {
                ProgramExitStatus programExitStatus = status;
                return programExitStatus;
            }
            ProgramExitStatus programExitStatus = this.processCommand();
            return programExitStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.out.close();
        }
    }

    protected void setupCmds(AbstractCommand ... cmds) {
        for (AbstractCommand cmd : cmds) {
            this.argumentParser.addCommand(cmd);
        }
    }

    protected void parseArgs(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        this.originalArguments = (String[])args.clone();
        this.argumentParser.parse(args);
        if (this.commandBasicOptions.output != null) {
            this.out = IrCoreUtils.getPrintStream(this.commandBasicOptions.output, this.commandBasicOptions.outputEncoding);
        }
        this.command = this.commandBasicOptions.helpRequested ? "help" : (this.commandBasicOptions.versionRequested ? "version" : this.argumentParser.getParsedCommand());
    }

    protected ProgramExitStatus processHelpAndDescription() {
        if (this.command == null) {
            return new ProgramExitStatus(this.progName, 1, "Command missing.");
        }
        JCommander jCommander = this.argumentParser.getCommands().get(this.command);
        AbstractCommand cmd = (AbstractCommand)jCommander.getObjects().get(0);
        return cmd.process(this) ? new ProgramExitStatus() : null;
    }

    protected void setupLoggers() throws UsageException, IOException {
        Handler[] handlers;
        if (this.commandBasicOptions.logformat != null) {
            System.getProperties().setProperty("java.util.logging.SimpleFormatter.format", this.commandBasicOptions.logformat);
        }
        Logger topLevelLogger = Logger.getLogger("");
        Formatter formatter = this.commandBasicOptions.xmlLog ? new XMLFormatter() : new SimpleFormatter();
        for (Handler handler : handlers = topLevelLogger.getHandlers()) {
            topLevelLogger.removeHandler(handler);
        }
        String[] logclasses = this.commandBasicOptions.logclasses.split("\\|");
        ArrayList<Logger> loggers = new ArrayList<Logger>(logclasses.length);
        for (String logclass : logclasses) {
            Level level;
            String[] classLevel = logclass.trim().split(":");
            if (classLevel.length < 2) continue;
            Logger log = Logger.getLogger(classLevel[0].trim());
            loggers.add(log);
            try {
                level = Level.parse(classLevel[1].trim().toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException ex) {
                throw new UsageException(ex + ". Valid levels are: OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST, ALL.");
            }
            log.setLevel(level);
            log.setUseParentHandlers(false);
            StreamHandler handler = this.commandBasicOptions.logfile != null ? new FileHandler(this.commandBasicOptions.logfile) : new ConsoleHandler();
            handler.setLevel(level);
            handler.setFormatter(formatter);
            log.addHandler(handler);
        }
        StreamHandler handler = this.commandBasicOptions.logfile != null ? new FileHandler(this.commandBasicOptions.logfile) : new ConsoleHandler();
        handler.setFormatter(formatter);
        topLevelLogger.addHandler(handler);
        handler.setLevel(this.commandBasicOptions.logLevel);
        topLevelLogger.setLevel(this.commandBasicOptions.logLevel);
    }

    public void extraSetup() {
    }

    public abstract ProgramExitStatus processCommand();
}

